/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

class LeafBlockWrapper
extends AbstractBlockWrapper {
    private static final int CONTAIN_LINE_FEEDS = 4;
    private static final int READ_ONLY = 8;
    private static final int LEAF = 16;
    private final int mySymbolsAtTheLastLine;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myNextBlock;
    private SpacingImpl mySpaceProperty;
    private IndentInside myLastLineIndent;

    public LeafBlockWrapper(Block block, CompositeBlockWrapper parent, WhiteSpace whiteSpaceBefore, FormattingDocumentModel model, LeafBlockWrapper previousTokenBlock, boolean isReadOnly, TextRange textRange) {
        super(block, whiteSpaceBefore, parent, textRange);
        this.myPreviousBlock = previousTokenBlock;
        int lastLineNumber = model.getLineNumber(textRange.getEndOffset());
        int flagsValue = this.myFlags;
        boolean containsLineFeeds = model.getLineNumber(textRange.getStartOffset()) != lastLineNumber;
        flagsValue |= containsLineFeeds ? 4 : 0;
        this.mySymbolsAtTheLastLine = containsLineFeeds ? textRange.getEndOffset() - model.getLineStartOffset(lastLineNumber) : textRange.getLength();
        flagsValue |= isReadOnly ? 8 : 0;
        boolean isLeaf = block.isLeaf();
        this.myLastLineIndent = isLeaf && containsLineFeeds ? IndentInside.getLastLineIndent(((Object)model.getText(textRange)).toString()) : null;
        this.myFlags = flagsValue |= isLeaf ? 16 : 0;
    }

    public final boolean containsLineFeeds() {
        return (this.myFlags & 4) != 0;
    }

    public int getSymbolsAtTheLastLine() {
        return this.mySymbolsAtTheLastLine;
    }

    public LeafBlockWrapper getPreviousBlock() {
        return this.myPreviousBlock;
    }

    public LeafBlockWrapper getNextBlock() {
        return this.myNextBlock;
    }

    public void setNextBlock(LeafBlockWrapper nextBlock) {
        this.myNextBlock = nextBlock;
    }

    @Override
    protected boolean indentAlreadyUsedBefore(AbstractBlockWrapper child) {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPreviousBlock = null;
        this.myNextBlock = null;
        this.mySpaceProperty = null;
        this.myLastLineIndent = null;
    }

    public SpacingImpl getSpaceProperty() {
        return this.mySpaceProperty;
    }

    public IndentData calculateOffset(CodeStyleSettings.IndentOptions options) {
        if (this.myIndentFromParent != null) {
            AbstractBlockWrapper firstIndentedParent = this.findFirstIndentedParent();
            IndentData indentData = new IndentData(this.myIndentFromParent.getIndentSpaces(), this.myIndentFromParent.getSpaces());
            if (firstIndentedParent == null) {
                return indentData;
            }
            WhiteSpace whiteSpace = firstIndentedParent.getWhiteSpace();
            return new IndentData(whiteSpace.getIndentOffset(), whiteSpace.getSpaces()).add(indentData);
        }
        if (this.myParent == null) {
            return new IndentData(0);
        }
        if (this.getIndent().isAbsolute()) {
            this.setCanUseFirstChildIndentAsBlockIndent(false);
            AbstractBlockWrapper current = this;
            while (current != null && current.getStartOffset() == this.getStartOffset()) {
                current.setCanUseFirstChildIndentAsBlockIndent(false);
                current = current.myParent;
            }
        }
        ArrayList ignored = new ArrayList();
        IndentData result = this.myParent.getChildOffset(this, options, this.getStartOffset());
        if (!ignored.isEmpty()) {
            result = result.add((IndentData)ignored.get(ignored.size() - 1));
        }
        return result;
    }

    public void setSpaceProperty(SpacingImpl currentSpaceProperty) {
        this.mySpaceProperty = currentSpaceProperty;
    }

    @Nullable
    public IndentInfo calcIndentFromParent() {
        AbstractBlockWrapper firstIndentedParent = this.findFirstIndentedParent();
        WhiteSpace mySpace = this.getWhiteSpace();
        if (firstIndentedParent != null) {
            WhiteSpace parentSpace = firstIndentedParent.getWhiteSpace();
            return new IndentInfo(0, mySpace.getIndentOffset() - parentSpace.getIndentOffset(), mySpace.getSpaces() - parentSpace.getSpaces());
        }
        return null;
    }

    public final boolean isLeaf() {
        return (this.myFlags & 0x10) != 0;
    }

    public IndentInside getLastLineIndent() {
        return this.myLastLineIndent;
    }

    public boolean contains(int offset) {
        return this.myStart < offset && this.myEnd > offset;
    }

    public TextRange getTextRange() {
        return new TextRange(this.myStart, this.myEnd);
    }

    public String toString() {
        return "LeafBlockWrapper(" + this.myStart + "-" + this.myEnd + ")";
    }
}

