/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.usageView.UsageViewUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowRecentFindUsagesGroup
extends ActionGroup {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
        e.getPresentation().setVisible(project != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesGroup.getChildren must not return null");
            return anActionArray;
        }
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesGroup.getChildren must not return null");
            return anActionArray;
        }
        final FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        ArrayList<FindUsagesManager.SearchData> history = new ArrayList<FindUsagesManager.SearchData>(findUsagesManager.getFindUsageHistory());
        Collections.reverse(history);
        String description = ActionManager.getInstance().getAction("UsageView.ShowRecentFindUsages").getTemplatePresentation().getDescription();
        ArrayList<1> children = new ArrayList<1>(history.size());
        for (final FindUsagesManager.SearchData data : history) {
            PsiElement psiElement;
            if (data.myElements == null || (psiElement = data.myElements[0].getElement()) == null) continue;
            String scopeString = data.myOptions.searchScope == null ? null : data.myOptions.searchScope.getDisplayName();
            String text = FindBundle.message("recent.find.usages.action.popup", StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)), UsageViewUtil.getDescriptiveName(psiElement), scopeString == null ? ProjectScope.getAllScope((Project)psiElement.getProject()).getDisplayName() : scopeString);
            AnAction action = new AnAction(text, description, psiElement.getIcon(0)){

                public void actionPerformed(AnActionEvent e) {
                    findUsagesManager.rerunAndRecallFromHistory(data);
                }
            };
            children.add(action);
        }
        anActionArray = children.toArray(new AnAction[children.size()]);
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesGroup.getChildren must not return null");
    }
}

