/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FindPackageUsagesDialog
extends JavaFindUsagesDialog {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbClassesUsages;

    public FindPackageUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Override
    public JComponent getPreferredFocusedControl() {
        return this.myCbUsages;
    }

    @Override
    public void calcFindUsagesOptions(FindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isUsages = FindPackageUsagesDialog.isSelected(this.myCbUsages);
        if (FindPackageUsagesDialog.isToChange(this.myCbClassesUsages)) {
            options.isClassesUsages = FindPackageUsagesDialog.isSelected(this.myCbClassesUsages);
        }
        options.isSkipPackageStatements = false;
        options.isSkipImportStatements = false;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.what.group", new Object[0])));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message("find.what.usages.checkbox", new Object[0]), this.myFindUsagesOptions.isUsages, findWhatPanel, true);
        this.myCbClassesUsages = this.addCheckboxToPanel(FindBundle.message("find.what.usages.of.classes.and.interfaces", new Object[0]), this.myFindUsagesOptions.isClassesUsages, findWhatPanel, true);
        return findWhatPanel;
    }

    @Override
    protected void update() {
        if (this.myCbToSearchForTextOccurences != null) {
            if (FindPackageUsagesDialog.isSelected(this.myCbUsages)) {
                this.myCbToSearchForTextOccurences.makeSelectable();
            } else {
                this.myCbToSearchForTextOccurences.makeUnselectable(false);
            }
        }
        boolean hasSelected = FindPackageUsagesDialog.isSelected(this.myCbUsages) || FindPackageUsagesDialog.isSelected(this.myCbClassesUsages);
        this.setOKActionEnabled(hasSelected);
    }
}

