/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;

    ShowUsagesTableCellRenderer(UsageViewImpl usageView) {
        this.myUsageView = usageView;
    }

    @Override
    public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        UsageNode usageNode = value instanceof UsageNode ? (UsageNode)value : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        panel.setBackground(isSelected ? UIUtil.getListSelectionBackground() : (fileBgColor == null ? list.getBackground() : fileBgColor));
        panel.setForeground(isSelected ? UIUtil.getListSelectionForeground() : list.getForeground());
        if (usage == null) {
            panel.setLayout(new BorderLayout());
            if (column == 0) {
                panel.add(new JLabel("<html><body><b>" + value + "</b></body></html>", 0));
            }
            return panel;
        }
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        textChunks.setIpad(new Insets(0, 0, 0, 0));
        textChunks.setBorder(null);
        if (column == 0) {
            GroupNode parent = (GroupNode)usageNode.getParent();
            this.appendGroupText(parent, panel, fileBgColor);
            if (usage == NullUsage.INSTANCE) {
                textChunks.append("...<");
                textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                textChunks.append(">...");
            }
        } else if (usage != NullUsage.INSTANCE) {
            UsagePresentation presentation = usage.getPresentation();
            TextChunk[] text = presentation.getText();
            if (column == 1) {
                textChunks.setIcon(presentation.getIcon());
                if (text.length != 0) {
                    SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveAttributesWithColor(SimpleTextAttributes.fromTextAttributes((TextAttributes)text[0].getAttributes()), fileBgColor);
                    textChunks.append(text[0].getText(), attributes);
                }
            } else if (column == 2) {
                for (int i = 1; i < text.length; ++i) {
                    TextChunk textChunk = text[i];
                    SimpleTextAttributes attrs = SimpleTextAttributes.fromTextAttributes((TextAttributes)textChunk.getAttributes());
                    Color bg = UIUtil.getListSelectionBackground();
                    Color fg = UIUtil.getListSelectionForeground();
                    SimpleTextAttributes attributes = isSelected ? new SimpleTextAttributes(bg, fg, fg, attrs.getStyle()) : ShowUsagesTableCellRenderer.deriveAttributesWithColor(attrs, fileBgColor);
                    textChunks.append(textChunk.getText(), attributes);
                }
            } else assert (false) : column;
        }
        panel.add((Component)textChunks);
        return panel;
    }

    private static SimpleTextAttributes deriveAttributesWithColor(SimpleTextAttributes attributes, Color fileBgColor) {
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        return attributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground();
        } else {
            Color color;
            Project project;
            PsiFile psiFile;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)(project = this.myUsageView.getProject())).findFile(virtualFile)) != null && psiFile.isValid() && (color = FileColorManager.getInstance((Project)project).getRendererBackground(psiFile)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(GroupNode node, JPanel panel, Color fileBgColor) {
        UsageGroup group;
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(parentGroup, panel, fileBgColor);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer = new SimpleColoredComponent();
            renderer.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveAttributesWithColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer.append(group.getText((UsageView)this.myUsageView), attributes);
            renderer.append(" ", attributes);
            renderer.setIpad(new Insets(0, 0, 0, 0));
            renderer.setBorder(null);
            panel.add((Component)renderer);
        }
    }
}

