/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageTarget[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets != null) {
            usageTargets[0].findUsages();
            return;
        }
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, new PsiElementProcessor<PsiElement>(){

            public boolean execute(PsiElement element) {
                new PsiElement2UsageTargetAdapter(element).findUsages();
                return false;
            }
        });
    }

    public void update(AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project, Editor editor, PsiElementProcessor<PsiElement> processor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/actions/FindUsagesAction.chooseAmbiguousTargetAndPerform must not be null");
        }
        if (editor == null) {
            Messages.showMessageDialog((Project)project, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, processor, FindBundle.message("find.usages.ambiguous.title", new Object[0]));
            if (!chosen) {
                HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
            }
        }
    }
}

