/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchComponent;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.awt.event.FocusAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUtil {
    private static final Key<Direction> KEY = Key.create((String)"FindUtil.KEY");

    private FindUtil() {
    }

    @Nullable
    static VirtualFile getVirtualFile(@NotNull Editor myEditor) {
        if (myEditor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/FindUtil.getVirtualFile must not be null");
        }
        Project project = myEditor.getProject();
        PsiFile file = project != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(myEditor.getDocument()) : null;
        return file != null ? file.getVirtualFile() : null;
    }

    public static void findWordAtCaret(Project project, Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int start = 0;
        int end = document.getTextLength();
        if (!editor.getSelectionModel().hasSelection()) {
            char c;
            int i;
            for (i = caretOffset - 1; i >= 0; --i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                start = i + 1;
                break;
            }
            for (i = caretOffset; i < document.getTextLength(); ++i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                end = i;
                break;
            }
        } else {
            start = editor.getSelectionModel().getSelectionStart();
            end = editor.getSelectionModel().getSelectionEnd();
        }
        if (start >= end) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        String s = ((Object)text.subSequence(start, end)).toString();
        FindSettings.getInstance().addStringToFind(s);
        findManager.getFindInFileModel().setStringToFind(s);
        findManager.setFindWasPerformed();
        FindModel model = new FindModel();
        model.setStringToFind(s);
        model.setCaseSensitive(true);
        model.setWholeWordsOnly(!editor.getSelectionModel().hasSelection());
        JComponent header = editor.getHeaderComponent();
        if (header instanceof EditorSearchComponent) {
            EditorSearchComponent searchComponent = (EditorSearchComponent)header;
            searchComponent.setTextInField(model.getStringToFind());
        }
        findManager.setFindNextModel(model);
        FindUtil.doSearch(project, editor, caretOffset, true, model, true);
    }

    public static void find(final Project project, final Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final FindManager findManager = FindManager.getInstance((Project)project);
        String s = editor.getSelectionModel().getSelectedText();
        final FindModel model = (FindModel)findManager.getFindInFileModel().clone();
        if (s != null) {
            if (s.indexOf(10) >= 0) {
                model.setGlobal(false);
            } else {
                model.setStringToFind(s);
                model.setGlobal(true);
            }
        } else {
            model.setGlobal(true);
        }
        model.setReplaceState(false);
        model.setFindAllEnabled(PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
        findManager.showFindDialog(model, new Runnable(){

            @Override
            public void run() {
                int offset;
                if (model.isFindAll()) {
                    findManager.setFindNextModel(model);
                    FindUtil.findAll(project, editor, model);
                    return;
                }
                if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                    ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                    FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
                }
                if (model.isGlobal()) {
                    offset = model.isFromCursor() ? editor.getCaretModel().getOffset() : (model.isForward() ? 0 : editor.getDocument().getTextLength());
                } else {
                    if (!editor.getSelectionModel().hasSelection()) {
                        findManager.setFindNextModel(null);
                        return;
                    }
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                }
                findManager.setFindNextModel(null);
                findManager.getFindInFileModel().copyFrom(model);
                FindUtil.doSearch(project, editor, offset, true, model, true);
            }
        });
    }

    public static void findAll(Project project, Editor editor, FindModel findModel) {
        FindResult result;
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        ArrayList<UsageInfo2UsageAdapter> usages = new ArrayList<UsageInfo2UsageAdapter>();
        FindManager findManager = FindManager.getInstance((Project)project);
        findModel.setForward(true);
        int offset = 0;
        VirtualFile virtualFile = FindUtil.getVirtualFile(editor);
        while (offset < textLength && (result = findManager.findString(text, offset, findModel, virtualFile)).isStringFound()) {
            usages.add(new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, result.getStartOffset(), result.getEndOffset())));
            int prevOffset = offset;
            if (prevOffset != (offset = result.getEndOffset())) continue;
            ++offset;
        }
        UsageTarget[] usageTargets = new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(findModel.getStringToFind())};
        UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation(false, findModel);
        UsageViewManager.getInstance((Project)project).showUsages(usageTargets, usages.toArray(new Usage[usages.size()]), usageViewPresentation);
    }

    public static void searchBack(Project project, FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        FindUtil.searchBack(project, editor);
    }

    public static void searchBack(Project project, Editor editor) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed()) {
            FindUtil.find(project, editor);
            return;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setForward(!(model = (FindModel)model.clone()).isForward());
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else {
            editor.putUserData(KEY, null);
            offset = editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        FindUtil.searchAgain(project, editor, offset, model);
    }

    public static boolean searchAgain(Project project, FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        return FindUtil.searchAgain(project, editor);
    }

    public static boolean searchAgain(Project project, Editor editor) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed()) {
            FindUtil.find(project, editor);
            return false;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model = (FindModel)model.clone();
        if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else {
            editor.putUserData(KEY, null);
            offset = editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        return FindUtil.searchAgain(project, editor, offset, model);
    }

    private static boolean searchAgain(Project project, Editor editor, int offset, FindModel model) {
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        model.setFromCursor(false);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            FindUtil.replace(project, editor, offset, model);
            return true;
        }
        FindUtil.doSearch(project, editor, offset, true, model, true);
        return false;
    }

    public static void replace(final Project project, final Editor editor) {
        final FindManager findManager = FindManager.getInstance((Project)project);
        final FindModel model = (FindModel)findManager.getFindInFileModel().clone();
        final String s = editor.getSelectionModel().getSelectedText();
        if (s != null) {
            if (s.indexOf(10) >= 0) {
                model.setGlobal(false);
            } else {
                model.setStringToFind(s);
                model.setGlobal(true);
            }
        } else {
            model.setGlobal(true);
        }
        model.setReplaceState(true);
        findManager.showFindDialog(model, new Runnable(){

            @Override
            public void run() {
                int offset;
                if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                    ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                    FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
                }
                if (model.isGlobal()) {
                    if (model.isFromCursor()) {
                        offset = editor.getCaretModel().getOffset();
                        if (!model.isForward()) {
                            ++offset;
                        }
                    } else {
                        offset = model.isForward() ? 0 : editor.getDocument().getTextLength();
                    }
                } else {
                    if (!editor.getSelectionModel().hasSelection()) {
                        findManager.setFindNextModel(null);
                        return;
                    }
                    int n = offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                }
                if (s != null && editor.getSelectionModel().hasSelection() && s.equals(model.getStringToFind())) {
                    if (model.isFromCursor() && model.isForward()) {
                        offset = Math.min(editor.getSelectionModel().getSelectionStart(), offset);
                    } else if (model.isFromCursor() && !model.isForward()) {
                        offset = Math.max(editor.getSelectionModel().getSelectionEnd(), offset);
                    }
                }
                findManager.setFindNextModel(null);
                findManager.getFindInFileModel().copyFrom(model);
                FindUtil.replace(project, editor, offset, model);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(Project project, Editor editor, int offset, FindModel model) {
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
            return false;
        }
        document.startGuardedBlockChecking();
        boolean toPrompt = model.isPromptOnReplace();
        if (!toPrompt) {
            ((DocumentEx)document).setInBulkUpdate(true);
        }
        try {
            toPrompt = FindUtil.doReplace(project, editor, model, document, offset, toPrompt);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            if (!toPrompt) {
                ((DocumentEx)document).setInBulkUpdate(false);
            }
            document.stopGuardedBlockChecking();
        }
        return true;
    }

    private static boolean doReplace(Project project, Editor editor, FindModel model, final Document document, int caretOffset, boolean toPrompt) {
        FindManager findManager = FindManager.getInstance((Project)project);
        model = (FindModel)model.clone();
        int occurrences = 0;
        ArrayList<Pair<TextRange, String>> rangesToChange = new ArrayList<Pair<TextRange, String>>();
        boolean replaced = false;
        int offset = caretOffset;
        while (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            int newOffset;
            caretOffset = offset;
            FindResult result = FindUtil.doSearch(project, editor, offset, !replaced, model, toPrompt);
            if (result == null) break;
            int startResultOffset = result.getStartOffset();
            model.setFromCursor(true);
            if (toPrompt) {
                int promptResult = findManager.showPromptDialog(model, FindBundle.message("find.replace.dialog.title", new Object[0]));
                if (promptResult == 2) {
                    offset = model.isForward() ? result.getEndOffset() : startResultOffset;
                    continue;
                }
                if (promptResult == 1) break;
                if (promptResult == 3) {
                    toPrompt = false;
                    ((DocumentEx)document).setInBulkUpdate(true);
                }
            }
            int startOffset = result.getStartOffset();
            int endOffset = result.getEndOffset();
            String string = ((Object)document.getCharsSequence().subSequence(startOffset, endOffset)).toString();
            String toReplace = findManager.getStringToReplace(string, model, startOffset, document.getText());
            if (toReplace == null) break;
            boolean reallyReplace = toPrompt;
            TextRange textRange = FindUtil.doReplace(project, document, model, result, toReplace, reallyReplace, rangesToChange);
            int n = newOffset = model.isForward() ? textRange.getEndOffset() : textRange.getStartOffset();
            if (newOffset == offset) {
                newOffset += model.isForward() ? 1 : -1;
            }
            offset = newOffset;
            ++occurrences;
            if (!replaced) {
                editor.getCaretModel().moveToOffset(0);
            }
            replaced = true;
        }
        if (replaced) {
            if (!toPrompt) {
                CharSequence text = document.getCharsSequence();
                final StringBuilder newText = new StringBuilder(document.getTextLength());
                Collections.sort(rangesToChange, new Comparator<Pair<TextRange, String>>(){

                    @Override
                    public int compare(Pair<TextRange, String> o1, Pair<TextRange, String> o2) {
                        return ((TextRange)o1.getFirst()).getStartOffset() - ((TextRange)o2.getFirst()).getStartOffset();
                    }
                });
                int offsetBefore = 0;
                for (Pair pair : rangesToChange) {
                    TextRange range = (TextRange)pair.getFirst();
                    String replace = (String)pair.getSecond();
                    newText.append(text, offsetBefore, range.getStartOffset());
                    newText.append(replace);
                    offsetBefore = range.getEndOffset();
                    if (offsetBefore >= caretOffset) continue;
                    caretOffset += replace.length() - range.getLength();
                }
                newText.append(text, offsetBefore, text.length());
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                document.setText((CharSequence)newText);
                            }
                        });
                    }
                }, null, (Object)document);
                if (caretOffset > document.getTextLength()) {
                    caretOffset = document.getTextLength();
                }
            }
            editor.getCaretModel().moveToOffset(caretOffset);
        }
        ReplaceInProjectManager.reportNumberReplacedOccurences(project, occurrences);
        return replaced;
    }

    @Nullable
    private static FindResult doSearch(Project project, final Editor editor, int offset, boolean toWarn, FindModel model, boolean adjustEditor) {
        FindManager findManager = FindManager.getInstance((Project)project);
        Document document = editor.getDocument();
        final FindResult result = findManager.findString(document.getCharsSequence(), offset, model, FindUtil.getVirtualFile(editor));
        boolean isFound = result.isStringFound();
        if (!(model.isGlobal() || result.getEndOffset() <= editor.getSelectionModel().getSelectionEnd() && result.getStartOffset() >= editor.getSelectionModel().getSelectionStart())) {
            isFound = false;
        }
        if (!isFound) {
            if (toWarn) {
                FindUtil.processNotFound(editor, model.getStringToFind(), model, project);
            }
            return null;
        }
        if (adjustEditor) {
            ScrollType scrollType;
            CaretModel caretModel = editor.getCaretModel();
            final ScrollingModel scrollingModel = editor.getScrollingModel();
            int oldCaretOffset = caretModel.getOffset();
            boolean forward = oldCaretOffset < result.getStartOffset();
            ScrollType scrollType2 = scrollType = forward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            if (model.isGlobal()) {
                caretModel.moveToOffset(result.getEndOffset());
                editor.getSelectionModel().removeSelection();
                scrollingModel.scrollToCaret(scrollType);
                scrollingModel.runActionOnScrollingFinished(new Runnable(){

                    @Override
                    public void run() {
                        scrollingModel.scrollTo(editor.offsetToLogicalPosition(result.getStartOffset()), scrollType);
                        scrollingModel.scrollTo(editor.offsetToLogicalPosition(result.getEndOffset()), scrollType);
                    }
                });
            } else {
                FindUtil.moveCaretAndDontChangeSelection(editor, result.getStartOffset(), scrollType);
                FindUtil.moveCaretAndDontChangeSelection(editor, result.getEndOffset(), scrollType);
            }
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes selectionAttributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (!model.isGlobal()) {
                RangeHighlighterEx segmentHighlighter = (RangeHighlighterEx)editor.getMarkupModel().addRangeHighlighter(result.getStartOffset(), result.getEndOffset(), 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
                MyListener listener = new MyListener(editor, segmentHighlighter);
                editor.getContentComponent().addFocusListener(listener);
                caretModel.addCaretListener((CaretListener)listener);
            } else {
                editor.getSelectionModel().setSelection(result.getStartOffset(), result.getEndOffset());
            }
        }
        return result;
    }

    private static void processNotFound(final Editor editor, String stringToFind, FindModel model, Project project) {
        String message = FindBundle.message("find.search.string.not.found.message", stringToFind);
        if (model.isGlobal()) {
            FindModel modelForNextSearch;
            FindModel newModel = (FindModel)model.clone();
            FindManager findManager = FindManager.getInstance((Project)project);
            Document document = editor.getDocument();
            FindResult result = newModel.isForward() ? findManager.findString(document.getCharsSequence(), 0, model, FindUtil.getVirtualFile(editor)) : findManager.findString(document.getCharsSequence(), document.getTextLength(), model, FindUtil.getVirtualFile(editor));
            if (!result.isStringFound()) {
                result = null;
            }
            if ((modelForNextSearch = findManager.getFindNextModel(editor)) == null) {
                modelForNextSearch = findManager.getFindInFileModel();
            }
            if (result != null) {
                AnAction action;
                if (newModel.isForward()) {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = shortcutsText.length() > 0 ? FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.DOWN);
                } else {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindPrevious" : "FindNext");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = shortcutsText.length() > 0 ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.UP);
                }
            }
            CaretListener listener = new CaretListener(){

                public void caretPositionChanged(CaretEvent e) {
                    editor.putUserData(KEY, null);
                    editor.getCaretModel().removeCaretListener((CaretListener)this);
                }
            };
            editor.getCaretModel().addCaretListener(listener);
        }
        JLabel component = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    private static TextRange doReplace(Project project, final Document document, FindModel model, FindResult result, @NotNull String stringToReplace, boolean reallyReplace, List<Pair<TextRange, String>> rangesToChange) {
        int start;
        int end;
        block9: {
            String toFind;
            block10: {
                block11: {
                    int newOffset;
                    if (stringToReplace == null) {
                        throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/find/FindUtil.doReplace must not be null");
                    }
                    final int startOffset = result.getStartOffset();
                    final int endOffset = result.getEndOffset();
                    final String converted = StringUtil.convertLineSeparators((String)stringToReplace);
                    if (reallyReplace) {
                        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                            @Override
                            public void run() {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        document.replaceString(startOffset, endOffset, (CharSequence)converted);
                                    }
                                });
                            }
                        }, null, (Object)document);
                        newOffset = startOffset + converted.length();
                    } else {
                        TextRange textRange = new TextRange(startOffset, endOffset);
                        rangesToChange.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)converted));
                        newOffset = endOffset;
                    }
                    if (!model.isRegularExpressions()) break block9;
                    toFind = model.getStringToFind();
                    if (!model.isForward()) break block10;
                    if (!StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) break block11;
                    int i = 0;
                    int length = toFind.length();
                    while (i + 2 <= length && toFind.charAt(length - i - 2) == '\\') {
                        ++i;
                    }
                    if (i % 2 != 0) break block9;
                    ++end;
                    break block9;
                }
                if (!StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) break block9;
                for (end = newOffset; end < document.getTextLength() && document.getCharsSequence().charAt(end) != '\n'; ++end) {
                }
                break block9;
            }
            if (StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) {
                --start;
            } else if (StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) {
                for (start = startOffset; start >= 0 && document.getCharsSequence().charAt(start) != '\n'; --start) {
                }
            }
        }
        return new TextRange(start, end);
    }

    private static void moveCaretAndDontChangeSelection(Editor editor, int offset, ScrollType scrollType) {
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getScrollingModel().scrollToCaret(scrollType);
    }

    private static class MyListener
    extends FocusAdapter
    implements CaretListener {
        private final Editor myEditor;
        private final RangeHighlighter mySegmentHighlighter;

        private MyListener(Editor editor, RangeHighlighter segmentHighlighter) {
            this.myEditor = editor;
            this.mySegmentHighlighter = segmentHighlighter;
        }

        public void caretPositionChanged(CaretEvent e) {
            this.removeAll();
        }

        private void removeAll() {
            this.myEditor.getMarkupModel().removeHighlighter(this.mySegmentHighlighter);
            this.myEditor.getContentComponent().addFocusListener(this);
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

