/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.actions;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShowFeatureUsageStatisticsDialog
extends DialogWrapper {
    private static final Comparator<FeatureDescriptor> DISPLAY_NAME_COMPARATOR = new Comparator<FeatureDescriptor>(){

        @Override
        public int compare(FeatureDescriptor fd1, FeatureDescriptor fd2) {
            String displayName1 = fd1.getDisplayName();
            String displayName2 = fd2.getDisplayName();
            if (displayName1 != null && displayName2 != null) {
                return displayName1.compareTo(displayName2);
            }
            if (displayName2 != null) {
                return -1;
            }
            return 1;
        }
    };
    private static final Comparator<FeatureDescriptor> GROUP_NAME_COMPARATOR = new Comparator<FeatureDescriptor>(){

        @Override
        public int compare(FeatureDescriptor fd1, FeatureDescriptor fd2) {
            return ShowFeatureUsageStatisticsDialog.getGroupName(fd1).compareTo(ShowFeatureUsageStatisticsDialog.getGroupName(fd2));
        }
    };
    private static final Comparator<FeatureDescriptor> USAGE_COUNT_COMPARATOR = new Comparator<FeatureDescriptor>(){

        @Override
        public int compare(FeatureDescriptor fd1, FeatureDescriptor fd2) {
            return fd1.getUsageCount() - fd2.getUsageCount();
        }
    };
    private static final Comparator<FeatureDescriptor> LAST_USED_COMPARATOR = new Comparator<FeatureDescriptor>(){

        @Override
        public int compare(FeatureDescriptor fd1, FeatureDescriptor fd2) {
            return new Date(fd2.getLastTimeUsed()).compareTo(new Date(fd1.getLastTimeUsed()));
        }
    };
    private static final Comparator<FeatureDescriptor> FREQUENCY_COMPARATOR = new Comparator<FeatureDescriptor>(){

        @Override
        public int compare(FeatureDescriptor fd1, FeatureDescriptor fd2) {
            return new Date(fd1.getAverageFrequency()).compareTo(new Date(fd2.getAverageFrequency()));
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> DISPLAY_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.feature", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return featureDescriptor.getDisplayName();
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return DISPLAY_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> GROUP_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.group", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return ShowFeatureUsageStatisticsDialog.getGroupName(featureDescriptor);
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return GROUP_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> USED_TOTAL = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.usage.count", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            int count = featureDescriptor.getUsageCount();
            return FeatureStatisticsBundle.message((String)"feature.statistics.usage.count", (Object[])new Object[]{count});
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return USAGE_COUNT_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> LAST_USED = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.last.used", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            long tm = featureDescriptor.getLastTimeUsed();
            if (tm <= 0L) {
                return FeatureStatisticsBundle.message((String)"feature.statistics.not.applicable", (Object[])new Object[0]);
            }
            return DateFormatUtil.formatBetweenDates((long)tm, (long)System.currentTimeMillis());
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return LAST_USED_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> USAGE_FREQUENCY = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.usage.frequency", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            long tm = featureDescriptor.getAverageFrequency();
            if (tm <= 0L) {
                return FeatureStatisticsBundle.message((String)"feature.statistics.not.applicable", (Object[])new Object[0]);
            }
            return DateFormatUtil.formatFrequency((long)tm);
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return FREQUENCY_COMPARATOR;
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{DISPLAY_NAME, GROUP_NAME, USED_TOTAL, LAST_USED, USAGE_FREQUENCY};
    private final Project myProject;

    public ShowFeatureUsageStatisticsDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.setModal(false);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.featureStatistics.actions.ShowFeatureUsageStatisticsDialog";
    }

    protected Action[] createActions() {
        return new Action[]{this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.productivityGuide");
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerControls(true);
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        Set ids = registry.getFeatureIds();
        ArrayList<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();
        for (String id : ids) {
            features.add(registry.getFeatureDescriptor(id));
        }
        final TableView table = new TableView(new ListTableModel(COLUMNS, features, 0));
        JPanel controlsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        Application app = ApplicationManager.getApplication();
        long uptime = System.currentTimeMillis() - app.getStartTime();
        long idletime = app.getIdleTime();
        String uptimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.uptime", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), DateFormatUtil.formatDuration((long)uptime)});
        String idleTimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.idle.time", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), DateFormatUtil.formatDuration((long)idletime)});
        controlsPanel.add((Component)new JLabel(uptimeS + ", " + idleTimeS), "North");
        final JCheckBox compiler = new JCheckBox(FeatureStatisticsBundle.message((String)"feature.statistics.show.while.compiling", (Object[])new Object[0]));
        compiler.setSelected(FeatureUsageTracker.getInstance().SHOW_IN_COMPILATION_PROGRESS);
        compiler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureUsageTracker.getInstance().SHOW_IN_COMPILATION_PROGRESS = compiler.isSelected();
            }
        });
        compiler.setVisible(this.haveCompilerExtensionPoint());
        final JCheckBox other = new JCheckBox(FeatureStatisticsBundle.message((String)"feature.statistics.show.on.startup", (Object[])new Object[0]));
        other.setSelected(FeatureUsageTracker.getInstance().SHOW_IN_OTHER_PROGRESS);
        other.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureUsageTracker.getInstance().SHOW_IN_OTHER_PROGRESS = other.isSelected();
            }
        });
        controlsPanel.add(compiler);
        controlsPanel.add(other);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)controlsPanel, "North");
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)table), "Center");
        splitter.setFirstComponent((JComponent)topPanel);
        final JEditorPane browser = new JEditorPane("text/html", "");
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((JComponent)browser));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Collection selection = table.getSelection();
                try {
                    if (selection.isEmpty()) {
                        browser.read(new StringReader(""), null);
                    } else {
                        FeatureDescriptor feature = (FeatureDescriptor)selection.iterator().next();
                        TipUIUtil.openTipInBrowser(feature.getTipFileName(), browser, feature.getProvider());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        return splitter;
    }

    private boolean haveCompilerExtensionPoint() {
        ExtensionPoint[] extensionPoints;
        for (ExtensionPoint extensionPoint : extensionPoints = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoints()) {
            if (!extensionPoint.getName().equals("com.intellij.compiler")) continue;
            return true;
        }
        return false;
    }

    private static String getGroupName(FeatureDescriptor featureDescriptor) {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        GroupDescriptor groupDescriptor = registry.getGroupDescriptor(featureDescriptor.getGroupId());
        return groupDescriptor != null ? groupDescriptor.getDisplayName() : "";
    }
}

