/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries.versions;

import com.intellij.facet.impl.ui.libraries.versions.LibrariesConfigurationInfo;
import com.intellij.facet.impl.ui.libraries.versions.LibraryConfigurationInfo;
import com.intellij.facet.impl.ui.libraries.versions.LibraryVersionInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesConfigurationManager
implements Disposable {
    private static final String STRING_DELIMITER = ",";
    private static final String RI_TEMPLATE = "$RI$";
    private static final String VERSION_TEMPLATE = "$VERSION$";

    @NotNull
    public static Map<LibraryVersionInfo, List<LibraryInfo>> getLibraries(URL ... urls) {
        HashMap versionLibs = new HashMap();
        for (URL url : urls) {
            LibrariesConfigurationInfo libs = (LibrariesConfigurationInfo)XmlSerializer.deserialize((URL)url, LibrariesConfigurationInfo.class);
            assert (libs != null);
            assert (libs.getLibraryConfigurationInfos() != null);
            String defaultVersion = libs.getDefaultVersion();
            String defaultRI = libs.getDefaultRI();
            String defaultDownloadUrl = libs.getDefaultDownloadUrl();
            String defaultPresentationUrl = libs.getDefaultPresentationUrl();
            for (LibraryConfigurationInfo libInfo : libs.getLibraryConfigurationInfos()) {
                String[] libInfoVersions = LibrariesConfigurationManager.getSplitted(libInfo.getVersion());
                if (libInfoVersions.length == 0) {
                    LibrariesConfigurationManager.addVersionLibrary(null, (Map<LibraryVersionInfo, List<LibraryInfo>>)versionLibs, defaultVersion, defaultRI, defaultDownloadUrl, defaultPresentationUrl, libInfo);
                    continue;
                }
                for (String infoVersion : libInfoVersions) {
                    LibrariesConfigurationManager.addVersionLibrary(infoVersion.trim(), (Map<LibraryVersionInfo, List<LibraryInfo>>)versionLibs, defaultVersion, defaultRI, defaultDownloadUrl, defaultPresentationUrl, libInfo);
                }
            }
        }
        HashMap hashMap = versionLibs;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/versions/LibrariesConfigurationManager.getLibraries must not return null");
        }
        return hashMap;
    }

    private static void addVersionLibrary(@Nullable String infoVersion, Map<LibraryVersionInfo, List<LibraryInfo>> versionLibs, String defaultVersion, String defaultRI, String defaultDownloadUrl, String defaultPresentationUrl, LibraryConfigurationInfo libInfo) {
        String version = LibrariesConfigurationManager.choose(infoVersion, defaultVersion);
        assert (!StringUtil.isEmptyOrSpaces((String)version));
        String ri = LibrariesConfigurationManager.choose(libInfo.getRI(), defaultRI);
        String downloadUrl = LibrariesConfigurationManager.choose(libInfo.getDownloadUrl(), defaultDownloadUrl);
        String presentationdUrl = LibrariesConfigurationManager.choose(libInfo.getPresentationdUrl(), defaultPresentationUrl);
        LibraryVersionInfo versionInfo = new LibraryVersionInfo(version, ri);
        LibraryInfo info = LibrariesConfigurationManager.createLibraryInfo(downloadUrl, presentationdUrl, version, ri, libInfo);
        if (versionLibs.get(versionInfo) == null) {
            versionLibs.put(versionInfo, new ArrayList());
        }
        versionLibs.get(versionInfo).add(info);
    }

    @Nullable
    private static String choose(@Nullable String str, @Nullable String defaultStr) {
        return StringUtil.isEmptyOrSpaces((String)str) ? defaultStr : str;
    }

    private static LibraryInfo createLibraryInfo(String downloadUrl, String presentationdUrl, String version, String ri, LibraryConfigurationInfo libInfo) {
        downloadUrl = downloadUrl.replace(VERSION_TEMPLATE, version);
        if (ri != null) {
            downloadUrl = downloadUrl.replace(RI_TEMPLATE, ri);
        }
        String jarName = libInfo.getJarName();
        String jarVersion = libInfo.getJarVersion();
        return new LibraryInfo(jarName, jarVersion == null ? version : jarVersion, downloadUrl + jarName, presentationdUrl, LibrariesConfigurationManager.getSplitted(libInfo.getRequiredClasses()));
    }

    private static String[] getSplitted(@Nullable String s) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return ArrayUtil.toStringArray((Collection)StringUtil.split((String)s, (String)STRING_DELIMITER));
    }

    public void dispose() {
    }
}

