/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadingMirrorsMap {
    private final Map<RemoteRepositoryInfo, String> myMirrors = new HashMap<RemoteRepositoryInfo, String>();

    public LibraryDownloadingMirrorsMap() {
    }

    public LibraryDownloadingMirrorsMap(RemoteRepositoryInfo[] remoteRepositories) {
        for (RemoteRepositoryInfo remoteRepository : remoteRepositories) {
            this.registerRepository(remoteRepository);
        }
    }

    public void registerRepository(RemoteRepositoryInfo remoteRepository) {
        if (!this.myMirrors.containsKey(remoteRepository)) {
            this.myMirrors.put(remoteRepository, remoteRepository.getDefaultMirror());
        }
    }

    public LibraryDownloadingMirrorsMap(LibraryDownloadInfo[] libraryDownloadInfos) {
        for (LibraryDownloadInfo downloadInfo : libraryDownloadInfos) {
            RemoteRepositoryInfo remoteRepository = downloadInfo.getRemoteRepository();
            if (remoteRepository == null) continue;
            this.registerRepository(remoteRepository);
        }
    }

    public List<RemoteRepositoryInfo> getRemoteRepositories() {
        return new ArrayList<RemoteRepositoryInfo>(this.myMirrors.keySet());
    }

    public String getDownloadingUrl(LibraryDownloadInfo downloadInfo) {
        String mirror = this.getSelectedMirror(downloadInfo);
        if (mirror != null) {
            return downloadInfo.getDownloadUrl(mirror);
        }
        return downloadInfo.getDownloadUrl();
    }

    @Nullable
    private String getSelectedMirror(@NotNull LibraryDownloadInfo downloadInfo) {
        if (downloadInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryDownloadingMirrorsMap.getSelectedMirror must not be null");
        }
        RemoteRepositoryInfo remoteRepository = downloadInfo.getRemoteRepository();
        return remoteRepository != null ? this.myMirrors.get(remoteRepository) : null;
    }

    public String getSelectedMirror(@NotNull RemoteRepositoryInfo remoteRepository) {
        if (remoteRepository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryDownloadingMirrorsMap.getSelectedMirror must not be null");
        }
        return this.myMirrors.get(remoteRepository);
    }

    public String getPresentableUrl(LibraryDownloadInfo downloadInfo) {
        String mirror = this.getSelectedMirror(downloadInfo);
        if (mirror != null) {
            return downloadInfo.getPresentableUrl(mirror);
        }
        return downloadInfo.getPresentableUrl();
    }

    public void setMirror(RemoteRepositoryInfo remoteRepository, String mirror) {
        if (mirror == null) {
            return;
        }
        if (!(mirror = mirror.trim()).endsWith("/")) {
            mirror = mirror + "/";
        }
        this.myMirrors.put(remoteRepository, mirror);
    }

    public LibraryDownloadingMirrorsMap createCopy() {
        LibraryDownloadingMirrorsMap mirrorsMap = new LibraryDownloadingMirrorsMap();
        mirrorsMap.myMirrors.putAll(this.myMirrors);
        return mirrorsMap;
    }
}

