/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private Map<FacetTypeId, Collection<Facet>> myType2Facets;
    private Map<Pair<Facet, FacetTypeId>, Collection<Facet>> myChildFacets;
    private Facet[] mySortedFacets;

    @NotNull
    public Facet[] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet<Facet> facets = new LinkedHashSet<Facet>();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets, facet);
                }
                this.mySortedFacets = facets.toArray(new Facet[facets.size()]);
            }
        }
        if (this.mySortedFacets == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelBase.getSortedFacets must not return null");
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<Facet> facets, Facet facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets, underlyingFacet);
        }
        facets.add(facet);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (underlyingFacet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetModelBase.getFacetsByType must not be null");
        }
        if (this.myChildFacets == null) {
            MultiValuesMap children = new MultiValuesMap();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children.put((Object)Pair.create((Object)underlying, (Object)facet.getTypeId()), (Object)facet);
            }
            this.myChildFacets = new HashMap<Pair<Facet, FacetTypeId>, Collection<Facet>>();
            for (Pair pair : children.keySet()) {
                Collection facets2 = children.get((Object)pair);
                this.myChildFacets.put((Pair<Facet, FacetTypeId>)pair, Collections.unmodifiableCollection(facets2));
            }
        }
        Collection<Object> collection = (facets = this.myChildFacets.get(new Pair((Object)underlyingFacet, typeId))) != null ? facets : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelBase.getFacetsByType must not return null");
        }
        return collection;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetModelBase.getFacetName must not be null");
        }
        String string = facet.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelBase.getFacetName must not return null");
        }
        return string;
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name)) continue;
            return (F)f;
        }
        return null;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetModelBase.getFacetByType must not be null");
        }
        Collection<F> fs = this.getFacetsByType(underlyingFacet, typeId);
        return (F)(fs.isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> fasets = this.getFacetsByType(typeId);
        return (F)(fasets.isEmpty() ? null : (Facet)fasets.iterator().next());
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (this.myType2Facets == null) {
            MultiValuesMap type2Facets = new MultiValuesMap();
            this.myType2Facets = new HashMap<FacetTypeId, Collection<Facet>>();
            for (Facet facet : this.getAllFacets()) {
                type2Facets.put((Object)facet.getTypeId(), (Object)facet);
            }
            for (FacetTypeId id : type2Facets.keySet()) {
                Collection facets2 = type2Facets.get((Object)id);
                this.myType2Facets.put(id, Collections.unmodifiableCollection(facets2));
            }
        }
        Collection<Object> collection = (facets = this.myType2Facets.get(typeId)) != null ? facets : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelBase.getFacetsByType must not return null");
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }
}

