/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.impl.FacetState;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;

public class FacetLoadingErrorDescription
extends ConfigurationErrorDescription {
    private final Facet myUnderlyingFacet;
    private final FacetState myState;
    private final Module myModule;

    public FacetLoadingErrorDescription(Module module, String errorMessage, Facet underlyingFacet, FacetState state) {
        super(state.getName() + " (" + module.getName() + ")", ProjectBundle.message((String)"element.kind.name.facet", (Object[])new Object[0]), errorMessage);
        this.myModule = module;
        this.myUnderlyingFacet = underlyingFacet;
        this.myState = state;
    }

    public Facet getUnderlyingFacet() {
        return this.myUnderlyingFacet;
    }

    public FacetState getState() {
        return this.myState;
    }

    public Module getModule() {
        return this.myModule;
    }

    @Override
    public String getRemoveConfirmationMessage() {
        return ProjectBundle.message((String)"confirmation.message.would.you.like.to.remove.facet", (Object[])new Object[]{this.myState.getName(), this.myModule.getName()});
    }

    @Override
    public void removeInvalidElement() {
        FacetManagerImpl manager = (FacetManagerImpl)FacetManagerImpl.getInstance((Module)this.myModule);
        manager.removeInvalidFacet(this.myUnderlyingFacet, this.myState);
    }

    @Override
    public boolean isValid() {
        return !this.myModule.isDisposed();
    }
}

