/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestSuiteStack;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralToSMTRunnerEventsConvertor
implements GeneralTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GeneralToSMTRunnerEventsConvertor.class.getName());
    private final Map<String, SMTestProxy> myRunningTestsFullNameToProxy;
    private final Set<AbstractTestProxy> myFailedTestsSet;
    private final TestSuiteStack mySuitesStack;
    private final List<SMTRunnerEventsListener> myEventsListeners;
    private final SMTestProxy myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;

    public GeneralToSMTRunnerEventsConvertor(@NotNull SMTestProxy testsRootNode, @NotNull String testFrameworkName) {
        if (testsRootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.<init> must not be null");
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.<init> must not be null");
        }
        this.myRunningTestsFullNameToProxy = new HashMap<String, SMTestProxy>();
        this.myFailedTestsSet = new HashSet<AbstractTestProxy>();
        this.mySuitesStack = new TestSuiteStack();
        this.myEventsListeners = new ArrayList<SMTRunnerEventsListener>();
        this.myTestsRootNode = testsRootNode;
        this.myTestFrameworkName = testFrameworkName;
    }

    public void addEventsListener(SMTRunnerEventsListener listener) {
        this.myEventsListeners.add(listener);
    }

    public void onStartTesting() {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.pushSuite(GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode);
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestingStarted();
            }
        });
    }

    public void onFinishTesting() {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GeneralToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GeneralToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                if (!GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.equals(GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.getCurrentSuite())) {
                    GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setTerminated();
                    GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                }
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.clear();
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setFinished();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }
        });
    }

    @Override
    public void onTestStarted(final @NotNull String testName, final @Nullable String locationUrl) {
        if (testName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestStarted must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String fullName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                if (GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                    boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test [" + fullName + "] has been already started", inDebugMode);
                    if (inDebugMode) {
                        return;
                    }
                }
                SMTestProxy parentSuite = GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite();
                SMTestProxy testProxy = new SMTestProxy(testName, false, locationUrl);
                parentSuite.addChild(testProxy);
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
                testProxy.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestStarted(testProxy);
            }
        });
    }

    @Override
    public void onSuiteStarted(final @NotNull String suiteName, final @Nullable String locationUrl) {
        if (suiteName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onSuiteStarted must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy parentSuite = GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite();
                SMTestProxy newSuite = new SMTestProxy(suiteName, true, locationUrl);
                parentSuite.addChild(newSuite);
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.pushSuite(newSuite);
                newSuite.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newSuite);
            }
        });
    }

    @Override
    public void onTestFinished(final @NotNull String testName, final @Nullable int duration) {
        if (testName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestFinished must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                testProxy.setDuration(duration);
                testProxy.setFinished();
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.remove(fullTestName);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
            }
        });
    }

    @Override
    public void onSuiteFinished(final @NotNull String suiteName) {
        if (suiteName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onSuiteFinished must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy mySuite = GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.popSuite(suiteName);
                if (mySuite != null) {
                    mySuite.setFinished();
                    GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(mySuite);
                }
            }
        });
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onUncapturedOutput must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy currentProxy = GeneralToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    currentProxy.addStdErr(text);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    currentProxy.addSystemOutput(text);
                } else {
                    currentProxy.addStdOutput(text, outputType);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onError must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy currentProxy = GeneralToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                currentProxy.addError(localizedMessage, stackTrace);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final @Nullable String categoryName, final int testCount) {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull String testName, final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isTestError) {
        if (testName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestFailure must not be null");
        }
        if (localizedMessage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestFailure must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}" + ", message = {" + localizedMessage + "}" + ", stackTrace = {" + stackTrace + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName), inDebugMode);
                    if (inDebugMode) {
                        return;
                    }
                    if (!GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains(testProxy)) {
                        GeneralToSMTRunnerEventsConvertor.this.onTestStarted(testName, null);
                        testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                    }
                }
                if (GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains(testProxy)) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Duplicate failure for test [" + fullTestName + "]: msg = " + localizedMessage + ", stacktrace = " + stackTrace, inDebugMode);
                    if (inDebugMode) {
                        return;
                    }
                }
                if (testProxy == null) {
                    return;
                }
                testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
                GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.add(testProxy);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull String testName, final @NotNull String ignoreComment, final @Nullable String stackTrace) {
        if (testName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestIgnored must not be null");
        }
        if (ignoreComment == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestIgnored must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    boolean debugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, " + "message = {" + ignoreComment + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName), debugMode);
                    if (debugMode) {
                        return;
                    }
                    GeneralToSMTRunnerEventsConvertor.this.onTestStarted(testName, null);
                    testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                testProxy.setTestIgnored(ignoreComment, stackTrace);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull String testName, final @NotNull String text, final boolean stdOut) {
        if (testName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestOutput must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.onTestOutput must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, " + "isStdOut = " + stdOut + ", " + "text = {" + text + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                if (stdOut) {
                    testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT);
                } else {
                    testProxy.addStdErr(text);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final SMTestProxy getCurrentSuite() {
        SMTestProxy sMTestProxy;
        SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
        if (currentSuite != null) {
            sMTestProxy = currentSuite;
            if (sMTestProxy == null) throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.getCurrentSuite must not return null");
            return sMTestProxy;
        }
        this.logProblem("Current suite is undefined. Root suite will be used.");
        sMTestProxy = this.myTestsRootNode;
        if (sMTestProxy != null) return sMTestProxy;
        throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor.getCurrentSuite must not return null");
    }

    protected String getFullTestName(String testName) {
        return testName;
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    protected Set<AbstractTestProxy> getFailedTestsSet() {
        return Collections.unmodifiableSet(this.myFailedTestsSet);
    }

    @Nullable
    protected SMTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    protected void clearInternalSuitesStack() {
        this.mySuitesStack.clear();
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    private void fireOnTestingStarted() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootNode);
        }
    }

    private void fireOnTestingFinished() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootNode);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(SMTestProxy suite) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(SMTestProxy suite) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    public void dispose() {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GeneralToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed! " + GeneralToSMTRunnerEventsConvertor.this.dumpRunningTestsNames());
                }
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.clear();
            }
        });
    }

    private SMTestProxy findCurrentTestOrSuite() {
        SMTestProxy currentProxy = this.myRunningTestsFullNameToProxy.size() == 1 ? this.myRunningTestsFullNameToProxy.values().iterator().next() : (this.mySuitesStack.isEmpty() ? this.myTestsRootNode : this.getCurrentSuite());
        return currentProxy;
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    private void logProblem(String msg) {
        this.logProblem(msg, SMTestRunnerConnectionUtil.isInDebugMode());
    }

    private void logProblem(String msg, boolean throwError) {
        String text = GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + msg;
        if (throwError) {
            LOG.error(text);
        } else {
            LOG.warn(text);
        }
    }
}

