/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProcessProxyImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;

public class ProcessProxyFactoryImpl
extends ProcessProxyFactory {
    public ProcessProxy createCommandLineProxy(JavaCommandLine javaCmdLine) throws ExecutionException {
        ProcessProxyImpl proxy = null;
        if (ProcessProxyImpl.useLauncher()) {
            try {
                proxy = new ProcessProxyImpl();
                JavaParameters javaParameters = javaCmdLine.getJavaParameters();
                JavaSdkUtil.addRtJar(javaParameters.getClassPath());
                ParametersList vmParametersList = javaParameters.getVMParametersList();
                vmParametersList.defineProperty("idea.launcher.port", "" + proxy.getPortNumber());
                vmParametersList.defineProperty("idea.launcher.bin.path", PathManager.getBinPath());
                javaParameters.getProgramParametersList().prepend(javaParameters.getMainClass());
                javaParameters.setMainClass("com.intellij.rt.execution.application.AppMain");
            }
            catch (ProcessProxyImpl.NoMoreSocketsException e) {
                proxy = null;
            }
        }
        return proxy;
    }

    public ProcessProxy getAttachedProxy(ProcessHandler processHandler) {
        return processHandler != null ? (ProcessProxyImpl)processHandler.getUserData(ProcessProxyImpl.KEY) : null;
    }
}

