/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.junit2.segments.Extractor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.project.Project;
import java.io.Reader;
import java.nio.charset.Charset;

public class JUnitProcessHandler
extends OSProcessHandler {
    private final Extractor myOut;
    private final Extractor myErr;
    private final Charset myCharset;

    public JUnitProcessHandler(Process process, String commandLine, Charset charset) {
        super(process, commandLine);
        this.myOut = new Extractor(this.getProcess().getInputStream(), charset);
        this.myErr = new Extractor(this.getProcess().getErrorStream(), charset);
        this.myCharset = charset;
    }

    protected Reader createProcessOutReader() {
        return this.myOut.createReader();
    }

    protected Reader createProcessErrReader() {
        return this.myErr.createReader();
    }

    public Extractor getErr() {
        return this.myErr;
    }

    public Extractor getOut() {
        return this.myOut;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public static JUnitProcessHandler runJava(JavaParameters javaParameters) throws ExecutionException {
        return JUnitProcessHandler.runJava(javaParameters, null);
    }

    public static JUnitProcessHandler runJava(JavaParameters javaParameters, Project project) throws ExecutionException {
        return JUnitProcessHandler.runCommandLine(CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)javaParameters, (Project)project, (boolean)true));
    }

    public static JUnitProcessHandler runCommandLine(GeneralCommandLine commandLine) throws ExecutionException {
        JUnitProcessHandler processHandler = new JUnitProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        return processHandler;
    }
}

