/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConfigurationSettingsEditorWrapper
extends SettingsEditor<RunnerAndConfigurationSettingsImpl> {
    public static DataKey<ConfigurationSettingsEditorWrapper> CONFIGURATION_EDITOR_KEY = DataKey.create((String)"ConfigurationSettingsEditor");
    private JPanel myComponentPlace;
    private JCheckBox myCbStoreProjectConfiguration;
    private JPanel myWholePanel;
    private JPanel myStepsPanel;
    private Map<Key<? extends BeforeRunTask>, BeforeRunTask> myStepsBeforeLaunch;
    private Map<Key<? extends BeforeRunTask>, StepBeforeLaunchRow> myStepBeforeLaunchRows;
    private boolean myStoreProjectConfiguration;
    private final ConfigurationSettingsEditor myEditor;

    public ConfigurationSettingsEditorWrapper(RunnerAndConfigurationSettingsImpl settings) {
        this.$$$setupUI$$$();
        this.myStepBeforeLaunchRows = new THashMap();
        this.myEditor = new ConfigurationSettingsEditor(settings);
        Disposer.register((Disposable)this, (Disposable)this.myEditor);
        this.doReset(settings);
    }

    private void doReset(RunnerAndConfigurationSettingsImpl settings) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(runConfiguration.getProject());
        this.myStepsBeforeLaunch = runManager.getBeforeRunTasks(runConfiguration);
        this.myStepBeforeLaunchRows.clear();
        BeforeRunTaskProvider[] providers = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)runConfiguration.getProject());
        this.myStepsPanel.removeAll();
        if (providers.length == 0 || runConfiguration instanceof UnknownRunConfiguration) {
            this.myStepsPanel.setVisible(false);
        } else {
            ArrayList<StepBeforeLaunchRow> stepsRows = new ArrayList<StepBeforeLaunchRow>();
            for (BeforeRunTaskProvider provider : providers) {
                BeforeRunTask task = this.myStepsBeforeLaunch.get(provider.getId());
                if (task == null) continue;
                StepBeforeLaunchRow stepRow = new StepBeforeLaunchRow(runConfiguration, (BeforeRunTaskProvider<BeforeRunTask>)provider, task);
                this.myStepBeforeLaunchRows.put((Key<? extends BeforeRunTask>)provider.getId(), stepRow);
                stepsRows.add(stepRow);
            }
            if (!stepsRows.isEmpty()) {
                this.myStepsPanel.setLayout(new GridLayout(stepsRows.size(), 1));
                for (StepBeforeLaunchRow stepRow : stepsRows) {
                    this.myStepsPanel.add(stepRow);
                }
            } else {
                this.myStepsPanel.setVisible(false);
            }
        }
        this.myStoreProjectConfiguration = runManager.isConfigurationShared(settings);
        this.myCbStoreProjectConfiguration.setEnabled(!(runConfiguration instanceof UnknownRunConfiguration));
        this.myCbStoreProjectConfiguration.setSelected(this.myStoreProjectConfiguration);
        this.myCbStoreProjectConfiguration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationSettingsEditorWrapper.this.myStoreProjectConfiguration = ConfigurationSettingsEditorWrapper.this.myCbStoreProjectConfiguration.isSelected();
            }
        });
        this.myCbStoreProjectConfiguration.setVisible(!settings.isTemplate());
    }

    @NotNull
    protected JComponent createEditor() {
        this.myComponentPlace.setLayout(new GridBagLayout());
        this.myComponentPlace.add((Component)this.myEditor.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myComponentPlace.doLayout();
        this.myWholePanel.putClientProperty("DataProvider", new TypeSafeDataProviderAdapter(new MyDataProvider()));
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/ConfigurationSettingsEditorWrapper.createEditor must not return null");
        }
        return jPanel;
    }

    public void updateBeforeRunTaskPanel(@NotNull Key<? extends BeforeRunTask> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/ConfigurationSettingsEditorWrapper.updateBeforeRunTaskPanel must not be null");
        }
        this.myStepBeforeLaunchRows.get(key).update(this.myStepsBeforeLaunch.get(key));
    }

    protected void disposeEditor() {
    }

    public void resetEditorFrom(RunnerAndConfigurationSettingsImpl settings) {
        this.myEditor.resetEditorFrom(settings);
        this.doReset(settings);
    }

    public void applyEditorTo(RunnerAndConfigurationSettingsImpl settings) throws ConfigurationException {
        this.myEditor.applyEditorTo(settings);
        this.doApply(settings);
    }

    public RunnerAndConfigurationSettingsImpl getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettingsImpl result = this.myEditor.getSnapshot();
        this.doApply(result);
        return result;
    }

    private void doApply(RunnerAndConfigurationSettingsImpl settings) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(runConfiguration.getProject());
        runManager.setBeforeRunTasks(runConfiguration, this.myStepsBeforeLaunch);
        runManager.shareConfiguration(runConfiguration, this.myStoreProjectConfiguration);
    }

    public Map<Key<? extends BeforeRunTask>, BeforeRunTask> getStepsBeforeLaunch() {
        return Collections.unmodifiableMap(this.myStepsBeforeLaunch);
    }

    public boolean isStoreProjectConfiguration() {
        return this.myStoreProjectConfiguration;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myComponentPlace = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myStepsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ExecutionBundle").getString("before.launch.panel.title"), 0, 0, null, null));
        this.myCbStoreProjectConfiguration = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("run.configuration.store.place.option"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDataProvider
    implements TypeSafeDataProvider {
        private MyDataProvider() {
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key.equals(CONFIGURATION_EDITOR_KEY)) {
                sink.put(CONFIGURATION_EDITOR_KEY, (Object)ConfigurationSettingsEditorWrapper.this);
            }
        }
    }

    private class StepBeforeLaunchRow
    extends JPanel {
        private final JCheckBox myCheckBox;
        private FixedSizeButton myButton;
        private final RunConfiguration myRunConfiguration;
        private final BeforeRunTaskProvider<BeforeRunTask> myProvider;

        public StepBeforeLaunchRow(final RunConfiguration runConfiguration, final BeforeRunTaskProvider<BeforeRunTask> provider, final BeforeRunTask beforeRunTask) {
            super(new GridBagLayout());
            this.myRunConfiguration = runConfiguration;
            this.myProvider = provider;
            boolean isChecked = beforeRunTask.isEnabled();
            this.myCheckBox = new JCheckBox(provider.getDescription(runConfiguration, beforeRunTask), isChecked);
            GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)this.myCheckBox, gc);
            gc.weightx = 1.0;
            if (provider.hasConfigurationButton()) {
                this.myButton = new FixedSizeButton(20);
                this.add((Component)this.myButton, gc);
                this.myButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (provider.configureTask(runConfiguration, beforeRunTask)) {
                            StepBeforeLaunchRow.this.myCheckBox.setText(provider.getDescription(runConfiguration, beforeRunTask));
                            ConfigurationSettingsEditorWrapper.this.fireEditorStateChanged();
                        }
                    }
                });
            } else {
                this.add((Component)Box.createHorizontalBox(), gc);
            }
            this.enableSettings(beforeRunTask);
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    beforeRunTask.setEnabled(StepBeforeLaunchRow.this.myCheckBox.isSelected());
                    StepBeforeLaunchRow.this.enableSettings(beforeRunTask);
                }
            });
        }

        private void enableSettings(BeforeRunTask task) {
            if (this.myButton != null) {
                this.myButton.setEnabled(this.myCheckBox.isSelected());
            }
            this.myCheckBox.setText(this.myProvider.getDescription(this.myRunConfiguration, task));
        }

        public void update(BeforeRunTask task) {
            this.myCheckBox.setSelected(task.isEnabled());
            this.enableSettings(task);
        }
    }
}

