/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;

public class TextConsoleBuilderImpl
extends TextConsoleBuilder {
    private final Project myProject;
    private final GlobalSearchScope myScope;
    private final ArrayList<Filter> myFilters = new ArrayList();
    private boolean myViewer;

    public TextConsoleBuilderImpl(Project project) {
        this(project, GlobalSearchScope.allScope((Project)project));
    }

    public TextConsoleBuilderImpl(Project project, GlobalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
    }

    public ConsoleView getConsole() {
        ConsoleViewImpl consoleView = this.createConsole();
        for (Filter filter : this.myFilters) {
            consoleView.addMessageFilter(filter);
        }
        return consoleView;
    }

    protected ConsoleViewImpl createConsole() {
        return new ConsoleViewImpl(this.myProject, this.myScope, this.myViewer, null);
    }

    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
    }

    public void setViewer(boolean isViewer) {
        this.myViewer = isViewer;
    }
}

