/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SideBorder;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class LanguageConsoleImpl
implements Disposable,
TypeSafeDataProvider {
    private static int SEPARATOR_THICKNESS = 1;
    private final Project myProject;
    private final EditorEx myConsoleEditor;
    private final EditorEx myHistoryViewer;
    private final Document myEditorDocument;
    protected PsiFile myFile;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private String myTitle;
    private String myPrompt = "> ";
    private LightVirtualFile myHistoryFile;
    private Editor myCurrentEditor;
    private final AtomicBoolean myForceScrollToEnd = new AtomicBoolean(false);
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myUiUpdateRunnable;

    public LanguageConsoleImpl(Project project, String title, Language language) {
        this.myProject = project;
        this.myTitle = title;
        this.installEditorFactoryListener();
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myHistoryFile = new LightVirtualFile(this.getTitle() + ".history.txt", (FileType)StdFileTypes.PLAIN_TEXT, (CharSequence)"");
        this.myEditorDocument = editorFactory.createDocument((CharSequence)"");
        this.setLanguage(language);
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, this.myProject);
        this.myCurrentEditor = this.myConsoleEditor;
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(((EditorFactoryImpl)editorFactory).createDocument(true), this.myProject);
        this.myPanel.add((Component)this.myHistoryViewer.getComponent(), "North");
        this.myPanel.add((Component)this.myConsoleEditor.getComponent(), "Center");
        this.setupComponents();
        this.myPanel.putClientProperty("DataProvider", new TypeSafeDataProviderAdapter(this));
        this.myUpdateQueue = new MergingUpdateQueue("ConsoleUpdateQueue", 300, true, null);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        this.myPanel.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                try {
                    LanguageConsoleImpl.this.myHistoryViewer.getScrollingModel().disableAnimation();
                    LanguageConsoleImpl.this.updateSizes(true);
                }
                finally {
                    LanguageConsoleImpl.this.myHistoryViewer.getScrollingModel().enableAnimation();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }
        });
    }

    private void setupComponents() {
        LanguageConsoleImpl.setupEditorDefault(this.myConsoleEditor);
        LanguageConsoleImpl.setupEditorDefault(this.myHistoryViewer);
        this.setPrompt(this.myPrompt);
        this.myConsoleEditor.addEditorMouseListener((EditorMouseListener)EditorActionUtil.createEditorPopupHandler("CutCopyPasteGroup"));
        if (SEPARATOR_THICKNESS > 0) {
            this.myHistoryViewer.getComponent().setBorder((Border)new SideBorder(Color.LIGHT_GRAY, 8));
        }
        this.myHistoryViewer.getComponent().setMinimumSize(new Dimension(0, 0));
        this.myHistoryViewer.getComponent().setPreferredSize(new Dimension(0, 0));
        this.myConsoleEditor.getSettings().setAdditionalLinesCount(2);
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile.getVirtualFile()));
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleEditor.setHorizontalScrollbarVisible(true);
        VisibleAreaListener areaListener = new VisibleAreaListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visibleAreaChanged(VisibleAreaEvent e) {
                int offset = LanguageConsoleImpl.this.myConsoleEditor.getScrollingModel().getHorizontalScrollOffset();
                ScrollingModel model = LanguageConsoleImpl.this.myHistoryViewer.getScrollingModel();
                int historyOffset = model.getHorizontalScrollOffset();
                if (historyOffset != offset) {
                    try {
                        model.disableAnimation();
                        model.scrollHorizontally(offset);
                    }
                    finally {
                        model.enableAnimation();
                    }
                }
            }
        };
        this.myConsoleEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        DocumentAdapter docListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                LanguageConsoleImpl.this.queueUiUpdate(false);
            }
        };
        this.myEditorDocument.addDocumentListener((DocumentListener)docListener, (Disposable)this);
        this.myHistoryViewer.getDocument().addDocumentListener((DocumentListener)docListener, (Disposable)this);
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    LanguageConsoleImpl.this.myConsoleEditor.getContentComponent().requestFocus();
                    LanguageConsoleImpl.this.myConsoleEditor.processKeyTyped(event);
                }
            }
        });
        for (AnAction action : this.createActions()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.myConsoleEditor.getComponent());
        }
        this.registerActionShortcuts(this.myHistoryViewer.getComponent());
    }

    protected AnAction[] createActions() {
        return AnAction.EMPTY_ARRAY;
    }

    private static void setupEditorDefault(EditorEx editor) {
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(true);
        editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.getScrollPane().setBorder(null);
        editor.getContentComponent().setFocusCycleRoot(false);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setAdditionalLinesCount(0);
        editorSettings.setAdditionalColumnsCount(1);
        editorSettings.setRightMarginShown(false);
        editorSettings.setFoldingOutlineShown(true);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineCursorWidth(1);
    }

    public void setUiUpdateRunnable(Runnable uiUpdateRunnable) {
        assert (this.myUiUpdateRunnable == null) : "can be set only once";
        this.myUiUpdateRunnable = uiUpdateRunnable;
    }

    public void flushAllUiUpdates() {
        this.myUpdateQueue.flush();
    }

    public LightVirtualFile getHistoryFile() {
        return this.myHistoryFile;
    }

    public String getPrompt() {
        return this.myPrompt;
    }

    public void setPrompt(String prompt) {
        this.myPrompt = prompt;
        ((EditorImpl)this.myConsoleEditor).setPrefixTextAndAttributes(this.myPrompt, ConsoleViewContentType.USER_INPUT.getAttributes());
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public EditorEx getHistoryViewer() {
        return this.myHistoryViewer;
    }

    public Document getEditorDocument() {
        return this.myEditorDocument;
    }

    public EditorEx getConsoleEditor() {
        return this.myConsoleEditor;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void addToHistory(String text, TextAttributes attributes) {
        this.printToHistory(text, attributes);
    }

    public void printToHistory(String text, TextAttributes attributes) {
        text = StringUtil.convertLineSeparators((String)text);
        boolean scrollToEnd = this.shouldScrollHistoryToEnd();
        Document history = this.myHistoryViewer.getDocument();
        MarkupModel markupModel = history.getMarkupModel(this.myProject);
        int offset = history.getTextLength();
        history.insertString(offset, (CharSequence)text);
        markupModel.addRangeHighlighter(offset, history.getTextLength(), 2000, attributes, HighlighterTargetArea.EXACT_RANGE);
        this.queueUiUpdate(scrollToEnd);
    }

    public String addCurrentToHistory(final TextRange textRange, final boolean erase) {
        final Ref ref = Ref.create((Object)"");
        boolean scrollToEnd = this.shouldScrollHistoryToEnd();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ref.set((Object)LanguageConsoleImpl.this.addTextRangeToHistory(textRange));
                if (erase) {
                    LanguageConsoleImpl.this.myConsoleEditor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                }
            }
        });
        this.queueUiUpdate(scrollToEnd);
        return (String)ref.get();
    }

    public boolean shouldScrollHistoryToEnd() {
        int lineCount;
        Rectangle visibleArea = this.myHistoryViewer.getScrollingModel().getVisibleArea();
        int lineNum = (visibleArea.y + visibleArea.height + this.myHistoryViewer.getLineHeight()) / this.myHistoryViewer.getLineHeight();
        return lineNum == (lineCount = this.myHistoryViewer.getDocument().getLineCount());
    }

    private void scrollHistoryToEnd() {
        int lineCount = this.myHistoryViewer.getDocument().getLineCount();
        if (lineCount == 0) {
            return;
        }
        this.myHistoryViewer.getCaretModel().moveToOffset(this.myHistoryViewer.getDocument().getLineStartOffset(lineCount - 1));
        this.myHistoryViewer.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    private String addTextRangeToHistory(TextRange textRange) {
        DocumentImpl history = (DocumentImpl)this.myHistoryViewer.getDocument();
        MarkupModel markupModel = history.getMarkupModel(this.myProject);
        int promptOffset = history.getTextLength();
        history.insertString(history.getTextLength(), this.myPrompt);
        markupModel.addRangeHighlighter(promptOffset, history.getTextLength(), 2000, ConsoleViewContentType.USER_INPUT.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
        int offset = history.getTextLength();
        String text = textRange.substring(this.myConsoleEditor.getDocument().getText());
        history.insertString(offset, text);
        HighlighterIterator iterator = this.myConsoleEditor.getHighlighter().createIterator(0);
        while (!iterator.atEnd()) {
            int end;
            int localOffset = textRange.getStartOffset();
            int start = Math.max(iterator.getStart(), localOffset) - localOffset;
            if (start <= (end = Math.min(iterator.getEnd(), textRange.getEndOffset()) - localOffset)) {
                markupModel.addRangeHighlighter(start + offset, end + offset, 2000, iterator.getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
            }
            iterator.advance();
        }
        LanguageConsoleImpl.duplicateHighlighters(markupModel, this.myConsoleEditor.getDocument().getMarkupModel(this.myProject), offset, textRange);
        LanguageConsoleImpl.duplicateHighlighters(markupModel, this.myConsoleEditor.getMarkupModel(), offset, textRange);
        if (!text.endsWith("\n")) {
            history.insertString(history.getTextLength(), "\n");
        }
        return text;
    }

    private static void duplicateHighlighters(MarkupModel to, MarkupModel from, int offset, TextRange textRange) {
        for (RangeHighlighter rangeHighlighter : from.getAllHighlighters()) {
            int end;
            int localOffset = textRange.getStartOffset();
            int start = Math.max(rangeHighlighter.getStartOffset(), localOffset) - localOffset;
            if (start > (end = Math.min(rangeHighlighter.getEndOffset(), textRange.getEndOffset()) - localOffset)) continue;
            RangeHighlighter h = to.addRangeHighlighter(start + offset, end + offset, rangeHighlighter.getLayer(), rangeHighlighter.getTextAttributes(), rangeHighlighter.getTargetArea());
            ((RangeHighlighterEx)h).setAfterEndOfLine(((RangeHighlighterEx)rangeHighlighter).isAfterEndOfLine());
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void queueUiUpdate(boolean forceScrollToEnd) {
        this.myForceScrollToEnd.compareAndSet(false, forceScrollToEnd);
        this.myUpdateQueue.queue(new Update("UpdateUi"){

            public void run() {
                if (Disposer.isDisposed((Disposable)LanguageConsoleImpl.this)) {
                    return;
                }
                LanguageConsoleImpl.this.updateSizes(LanguageConsoleImpl.this.myForceScrollToEnd.getAndSet(false));
                if (LanguageConsoleImpl.this.myUiUpdateRunnable != null) {
                    ApplicationManager.getApplication().runReadAction(LanguageConsoleImpl.this.myUiUpdateRunnable);
                }
            }
        });
    }

    private void updateSizes(boolean forceScrollToEnd) {
        Dimension panelSize = this.myPanel.getSize();
        Dimension historyContentSize = this.myHistoryViewer.getContentSize();
        Dimension contentSize = this.myConsoleEditor.getContentSize();
        Dimension newEditorSize = new Dimension();
        int minHistorySize = historyContentSize.height > 0 ? 2 * this.myHistoryViewer.getLineHeight() + SEPARATOR_THICKNESS : 0;
        int width = Math.max(contentSize.width, historyContentSize.width);
        newEditorSize.height = Math.min(Math.max(panelSize.height - minHistorySize, 2 * this.myConsoleEditor.getLineHeight()), contentSize.height + this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().getHeight());
        newEditorSize.width = width + this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().getHeight();
        this.myConsoleEditor.getSettings().setAdditionalColumnsCount(2 + (width - contentSize.width) / EditorUtil.getSpaceWidth(0, this.myConsoleEditor));
        this.myHistoryViewer.getSettings().setAdditionalColumnsCount(2 + (width - historyContentSize.width) / EditorUtil.getSpaceWidth(0, this.myHistoryViewer));
        Dimension editorSize = this.myConsoleEditor.getComponent().getSize();
        if (!editorSize.equals(newEditorSize)) {
            this.myConsoleEditor.getComponent().setPreferredSize(newEditorSize);
        }
        boolean scrollToEnd = forceScrollToEnd || this.shouldScrollHistoryToEnd();
        Dimension newHistorySize = new Dimension(width, Math.max(0, Math.min(minHistorySize == 0 ? 0 : historyContentSize.height + SEPARATOR_THICKNESS, panelSize.height - newEditorSize.height)));
        Dimension historySize = this.myHistoryViewer.getComponent().getSize();
        if (!historySize.equals(newHistorySize)) {
            this.myHistoryViewer.getComponent().setPreferredSize(newHistorySize);
        }
        this.myPanel.validate();
        if (scrollToEnd) {
            this.scrollHistoryToEnd();
        }
    }

    public void dispose() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        assert (virtualFile != null);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        boolean isOpen = editorManager.isFileOpen(virtualFile);
        if (isOpen) {
            editorManager.closeFile(virtualFile);
        }
    }

    public void calcData(DataKey key, DataSink sink) {
        if (OpenFileDescriptor.NAVIGATE_IN_EDITOR == key) {
            sink.put(OpenFileDescriptor.NAVIGATE_IN_EDITOR, (Object)this.myConsoleEditor);
            return;
        }
        Object o = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.getProject())).getData(key.getName(), this.myConsoleEditor, this.myFile.getVirtualFile());
        sink.put(key, o);
    }

    public void openInEditor() {
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        assert (virtualFile != null);
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), virtualFile, this.myConsoleEditor.getCaretModel().getOffset()), true);
    }

    private void installEditorFactoryListener() {
        final EditorFactoryListener factoryListener = new EditorFactoryListener(){

            public void editorCreated(EditorFactoryEvent event) {
                final Editor editor = event.getEditor();
                if (editor.getDocument() == LanguageConsoleImpl.this.myEditorDocument) {
                    if (LanguageConsoleImpl.this.myConsoleEditor != null) {
                        LanguageConsoleImpl.this.queueUiUpdate(false);
                        LanguageConsoleImpl.this.registerActionShortcuts(editor.getComponent());
                    }
                    editor.getCaretModel().addCaretListener(new CaretListener(){

                        public void caretPositionChanged(CaretEvent e) {
                            LanguageConsoleImpl.this.queueUiUpdate(false);
                        }
                    });
                    editor.getContentComponent().addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            LanguageConsoleImpl.this.myCurrentEditor = editor;
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                        }
                    });
                }
            }

            public void editorReleased(EditorFactoryEvent event) {
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(factoryListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().removeEditorFactoryListener(factoryListener);
            }
        });
    }

    protected void registerActionShortcuts(JComponent component) {
        ArrayList actionList = (ArrayList)this.myConsoleEditor.getComponent().getClientProperty("AnAction.shortcutSet");
        if (actionList != null) {
            for (AnAction anAction : actionList) {
                anAction.registerCustomShortcutSet(anAction.getShortcutSet(), component);
            }
        }
    }

    public Editor getCurrentEditor() {
        return this.myCurrentEditor;
    }

    public void setLanguage(Language language) {
        PsiFile prevFile = this.myFile;
        if (prevFile != null) {
            VirtualFile file = prevFile.getVirtualFile();
            assert (file instanceof LightVirtualFile);
            ((LightVirtualFile)file).setValid(false);
            ((PsiManagerEx)prevFile.getManager()).getFileManager().setViewProvider(file, null);
        }
        FileType type = language.getAssociatedFileType();
        String name = this.getTitle() + "." + (type == null ? "txt" : type.getDefaultExtension());
        LightVirtualFile newVFile = new LightVirtualFile(name, language, (CharSequence)this.myEditorDocument.getText());
        FileDocumentManagerImpl.registerDocument(this.myEditorDocument, (VirtualFile)newVFile);
        this.myFile = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)this.myProject)).trySetupPsiForFile(newVFile, language, true, false);
        if (this.myFile == null) {
            throw new AssertionError((Object)("file=null, name=" + name + ", language=" + language.getDisplayName()));
        }
        PsiDocumentManagerImpl.cachePsi(this.myEditorDocument, this.myFile);
        FileContentUtil.reparseFiles((Project)this.myProject, Collections.singletonList(newVFile), (boolean)false);
        if (prevFile != null) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
            VirtualFile file = prevFile.getVirtualFile();
            if (file != null && editorManager.isFileOpen(file)) {
                boolean focusEditor;
                int offset;
                FileEditor prevEditor = editorManager.getSelectedEditor(file);
                if (prevEditor != null) {
                    offset = prevEditor instanceof TextEditor ? ((TextEditor)prevEditor).getEditor().getCaretModel().getOffset() : 0;
                    Component owner = FocusManager.getCurrentManager().getFocusOwner();
                    focusEditor = owner != null && SwingUtilities.isDescendingFrom(owner, prevEditor.getComponent());
                } else {
                    focusEditor = false;
                    offset = 0;
                }
                editorManager.closeFile(file);
                editorManager.openTextEditor(new OpenFileDescriptor(this.getProject(), (VirtualFile)newVFile, offset), focusEditor);
            }
        }
    }

    public void setInputText(final String query) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.myConsoleEditor.getDocument().setText((CharSequence)query);
            }
        });
    }

    public static void printToConsole(LanguageConsoleImpl console, String string, ConsoleViewContentType type) {
        LanguageConsoleImpl.printToConsole(console, string, type.getAttributes());
    }

    public static void printToConsole(final LanguageConsoleImpl console, final String string, TextAttributes textAttributes) {
        TextAttributes outAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(ConsoleHighlighter.OUT);
        final TextAttributes attributes = TextAttributes.merge((TextAttributes)outAttrs, (TextAttributes)textAttributes);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                console.printToHistory(string, attributes);
            }
        }, ModalityState.stateForComponent((Component)console.getComponent()));
    }
}

