/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurationType
implements LocatableConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory((ConfigurationType)this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new ApplicationConfiguration("", project, ApplicationConfigurationType.this);
        }

        public Icon getIcon(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/application/ApplicationConfigurationType$1.getIcon must not be null");
            }
            return RunConfigurationExtension.getIcon((ApplicationConfiguration)configuration, this.getIcon());
        }
    };
    private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/application.png");

    public String getDisplayName() {
        return ExecutionBundle.message((String)"application.configuration.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"application.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location location) {
        return null;
    }

    public boolean isConfigurationByLocation(RunConfiguration configuration, Location location) {
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location.getPsiElement());
        if (aClass == null) {
            return false;
        }
        if (Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((ApplicationConfiguration)configuration).MAIN_CLASS_NAME)) {
            if (Comparing.equal((Object)location.getModule(), (Object)((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule())) {
                return true;
            }
            Module configurationModule = ((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            Module predefinedModule = ((JavaRunConfigurationModule)((ApplicationConfiguration)((RunManagerImpl)RunManagerEx.getInstanceEx(location.getProject())).getConfigurationTemplate(this.myFactory).getConfiguration()).getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }

    public static PsiClass getMainClass(PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (PsiMethodUtil.findMainInClass((PsiClass)aClass) != null) {
                    return aClass;
                }
            } else if (element instanceof PsiJavaFile) {
                PsiClass[] classes;
                PsiJavaFile javaFile = (PsiJavaFile)element;
                for (PsiClass aClass : classes = javaFile.getClasses()) {
                    if (PsiMethodUtil.findMainInClass((PsiClass)aClass) == null) continue;
                    return aClass;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("Application" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/application/ApplicationConfigurationType.getId must not return null");
        }
        return "Application";
    }

    @Nullable
    public static ApplicationConfigurationType getInstance() {
        return (ApplicationConfigurationType)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)CONFIGURATION_TYPE_EP), ApplicationConfigurationType.class);
    }
}

