/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.applet.AppletConfigurable;
import com.intellij.execution.applet.AppletConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppletConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements SingleClassConfiguration,
RefactoringListenerProvider {
    public String MAIN_CLASS_NAME;
    public String HTML_FILE_NAME;
    public boolean HTML_USED;
    public int WIDTH;
    public int HEIGHT;
    public String POLICY_FILE;
    public String VM_PARAMETERS;
    private AppletParameter[] myAppletParameters;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String VALUE_ATTR = "value";
    @NonNls
    protected static final String PARAMETER_ELEMENT_NAME = "parameter";

    public AppletConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
    }

    @Override
    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/applet/AppletConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/applet/AppletConfiguration.getState must not be null");
        }
        JavaCommandLineState state = new JavaCommandLineState(env){
            private AppletHtmlFile myHtmlURL;
            {
                this.myHtmlURL = null;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = new JavaParameters();
                this.myHtmlURL = AppletConfiguration.this.getHtmlURL();
                if (this.myHtmlURL != null) {
                    int classPathType = this.myHtmlURL.isHttp() ? 1 : 3;
                    RunConfigurationModule runConfigurationModule = AppletConfiguration.this.getConfigurationModule();
                    JavaParametersUtil.configureModule(runConfigurationModule, params, classPathType, AppletConfiguration.this.ALTERNATIVE_JRE_PATH_ENABLED ? AppletConfiguration.this.ALTERNATIVE_JRE_PATH : null);
                    String policyFileParameter = AppletConfiguration.this.getPolicyFileParameter();
                    if (policyFileParameter != null) {
                        params.getVMParametersList().add(policyFileParameter);
                    }
                    params.getVMParametersList().addParametersString(AppletConfiguration.this.VM_PARAMETERS);
                    params.setMainClass("sun.applet.AppletViewer");
                    params.getProgramParametersList().add(this.myHtmlURL.getUrl());
                }
                return params;
            }

            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler = super.startProcess();
                final AppletHtmlFile htmlUrl = this.myHtmlURL;
                if (htmlUrl != null) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            htmlUrl.deleteFile();
                        }
                    });
                }
                return handler;
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()));
        return state;
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AppletConfigurable(this.getProject());
    }

    @NonNls
    private String getPolicyFileParameter() {
        if (this.POLICY_FILE != null && this.POLICY_FILE.length() > 0) {
            return "-Djava.security.policy=" + this.getPolicyFile();
        }
        return null;
    }

    public void setPolicyFile(String localPath) {
        this.POLICY_FILE = ExternalizablePath.urlValue(localPath);
    }

    public String getPolicyFile() {
        return ExternalizablePath.localPathValue(this.POLICY_FILE);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.MAIN_CLASS_NAME);
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
        this.readModule(parentNode);
        ArrayList<AppletParameter> parameters = new ArrayList<AppletParameter>();
        for (Element element : parentNode.getChildren(PARAMETER_ELEMENT_NAME)) {
            String name = element.getAttributeValue(NAME_ATTR);
            String value = element.getAttributeValue(VALUE_ATTR);
            parameters.add(new AppletParameter(name, value));
        }
        this.myAppletParameters = parameters.toArray(new AppletParameter[parameters.size()]);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        this.writeModule(parentNode);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        if (this.myAppletParameters != null) {
            for (int i = 0; i < this.myAppletParameters.length; ++i) {
                Element element = new Element(PARAMETER_ELEMENT_NAME);
                parentNode.addContent(element);
                element.setAttribute(NAME_ATTR, this.myAppletParameters[i].getName());
                element.setAttribute(VALUE_ATTR, this.myAppletParameters[i].getValue());
            }
        }
    }

    protected ModuleBasedConfiguration createInstance() {
        return new AppletConfiguration(this.getName(), this.getProject(), AppletConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    public String getGeneratedName() {
        if (this.MAIN_CLASS_NAME == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.MAIN_CLASS_NAME, (JavaRunConfigurationModule)((JavaRunConfigurationModule)this.getConfigurationModule()));
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.HTML_USED) {
            return null;
        }
        return RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
    }

    @Override
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.MAIN_CLASS_NAME);
    }

    public void setGeneratedName() {
        this.setName(this.getGeneratedName());
    }

    public boolean isGeneratedName() {
        return Comparing.equal((String)this.getName(), (String)this.getGeneratedName());
    }

    public String suggestedName() {
        return ExecutionUtil.shortenName(JavaExecutionUtil.getShortClassName((String)this.MAIN_CLASS_NAME), 0);
    }

    @Override
    public void setMainClassName(String qualifiedName) {
        boolean generatedName = this.isGeneratedName();
        this.MAIN_CLASS_NAME = qualifiedName;
        if (generatedName) {
            this.setGeneratedName();
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.ALTERNATIVE_JRE_PATH_ENABLED && (this.ALTERNATIVE_JRE_PATH == null || this.ALTERNATIVE_JRE_PATH.length() == 0 || !JavaSdkImpl.checkForJre((String)this.ALTERNATIVE_JRE_PATH))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.not.valid.error.message", (Object[])new Object[]{this.ALTERNATIVE_JRE_PATH}));
        }
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
        if (this.HTML_USED) {
            if (this.HTML_FILE_NAME == null || this.HTML_FILE_NAME.length() == 0) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
        } else {
            ((JavaRunConfigurationModule)this.getConfigurationModule()).checkClassName(this.MAIN_CLASS_NAME, ExecutionBundle.message((String)"no.applet.class.specified.error.message", (Object[])new Object[0]));
        }
    }

    public AppletParameter[] getAppletParameters() {
        return this.myAppletParameters;
    }

    public void setAppletParameters(AppletParameter[] appletParameters) {
        this.myAppletParameters = appletParameters;
    }

    public void setAppletParameters(List<AppletParameter> parameters) {
        this.setAppletParameters(parameters.toArray(new AppletParameter[parameters.size()]));
    }

    private AppletHtmlFile getHtmlURL() throws CantRunException {
        if (this.HTML_USED) {
            if (this.HTML_FILE_NAME == null || this.HTML_FILE_NAME.length() == 0) {
                throw new CantRunException(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
            return new AppletHtmlFile(this.HTML_FILE_NAME, null);
        }
        if (this.MAIN_CLASS_NAME == null || this.MAIN_CLASS_NAME.length() == 0) {
            throw new CantRunException(ExecutionBundle.message((String)"class.not.specified.error.message", (Object[])new Object[0]));
        }
        try {
            return this.generateAppletTempPage();
        }
        catch (IOException e) {
            throw new CantRunException(ExecutionBundle.message((String)"failed.to.generate.wrapper.error.message", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletHtmlFile generateAppletTempPage() throws IOException {
        File tempFile = File.createTempFile("AppletPage", ".html");
        FileWriter writer = new FileWriter(tempFile);
        try {
            writer.write("<html>\n<head>\n<title>" + this.MAIN_CLASS_NAME + "</title>\n" + "</head>\n" + "<applet codebase=\".\"\n" + "code=\"" + this.MAIN_CLASS_NAME + "\"\n" + "name=\"" + this.MAIN_CLASS_NAME + "\"\n" + "width=" + this.WIDTH + "\n" + "height=" + this.HEIGHT + "\n" + "align=top>\n");
            AppletParameter[] appletParameters = this.getAppletParameters();
            if (appletParameters != null) {
                for (AppletParameter parameter : appletParameters) {
                    writer.write("<param name=\"" + parameter.getName() + "\" value=\"" + parameter.getValue() + "\">\n");
                }
            }
            writer.write("</applet>\n</body>\n</html>\n");
        }
        finally {
            writer.close();
        }
        String htmlFile = tempFile.getAbsolutePath();
        return new AppletHtmlFile(htmlFile, tempFile);
    }

    private static class AppletHtmlFile {
        private final String myHtmlFile;
        private final File myFileToDelete;
        @NonNls
        protected static final String FILE_PREFIX = "file:/";
        @NonNls
        protected static final String HTTP_PREFIX = "http:/";
        @NonNls
        protected static final String HTTPS_PREFIX = "https:/";

        protected AppletHtmlFile(String htmlFile, File fileToDelete) {
            this.myHtmlFile = htmlFile;
            this.myFileToDelete = fileToDelete;
        }

        public String getUrl() {
            if (!StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)FILE_PREFIX) && !this.isHttp()) {
                try {
                    return new File(this.myHtmlFile).toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return this.myHtmlFile;
        }

        public boolean isHttp() {
            return StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTP_PREFIX) || StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTPS_PREFIX);
        }

        public void deleteFile() {
            if (this.myFileToDelete != null) {
                this.myFileToDelete.delete();
            }
        }
    }

    public static class AppletParameter {
        public String myName;
        public String myValue;

        public AppletParameter(@NonNls String name, String value) {
            this.myName = name;
            this.myValue = value;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AppletParameter)) {
                return false;
            }
            AppletParameter second = (AppletParameter)obj;
            return Comparing.equal((String)this.myName, (String)second.myName) && Comparing.equal((String)this.myValue, (String)second.myValue);
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.myName, (Object)this.myValue);
        }
    }
}

