/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.ErrorTreeView;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance((String)ExecutionHelper.class.getName());

    private ExecutionHelper() {
    }

    public static void showErrors(final @NotNull Project myProject, final @NotNull List<Exception> exceptionList, final @NotNull String tabDisplayName, final @Nullable VirtualFile file) {
        if (myProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutionHelper.showErrors must not be null");
        }
        if (exceptionList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionHelper.showErrors must not be null");
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutionHelper.showErrors must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !exceptionList.isEmpty()) {
            throw new RuntimeException(exceptionList.get(0));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (myProject.isDisposed()) {
                    return;
                }
                if (exceptionList.isEmpty()) {
                    ExecutionHelper.removeContents(null, myProject, tabDisplayName);
                    return;
                }
                RailsErrorViewPanel errorTreeView = new RailsErrorViewPanel(myProject);
                try {
                    ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
                }
                catch (NullPointerException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Exceptions occured:");
                    for (Exception exception : exceptionList) {
                        builder.append("\n");
                        builder.append(exception.getMessage());
                    }
                    Messages.showErrorDialog((String)builder.toString(), (String)"Execution Error");
                    return;
                }
                for (Exception exception : exceptionList) {
                    String[] messages = StringUtil.splitByLines((String)exception.getMessage());
                    if (messages.length == 0) {
                        messages = new String[]{"Unknown Error"};
                    }
                    errorTreeView.addMessage(4, messages, file, -1, -1, null);
                }
                ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            }
        });
    }

    private static void openMessagesView(final @NotNull RailsErrorViewPanel errorTreeView, final @NotNull Project myProject, final @NotNull String tabDisplayName) {
        if (errorTreeView == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutionHelper.openMessagesView must not be null");
        }
        if (myProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionHelper.openMessagesView must not be null");
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutionHelper.openMessagesView must not be null");
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, new Runnable(){

            @Override
            public void run() {
                MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
                messageView.getContentManager().addContent(content);
                Disposer.register((Disposable)content, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content);
                ExecutionHelper.removeContents(content, myProject, tabDisplayName);
            }
        }, "Open message view", null);
    }

    private static void removeContents(@Nullable Content notToRemove, @NotNull Project myProject, @NotNull String tabDisplayName) {
        Content[] contents;
        if (myProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionHelper.removeContents must not be null");
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutionHelper.removeContents must not be null");
        }
        MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            LOG.assertTrue(content != null);
            if (content.isPinned() || !tabDisplayName.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    @Nullable
    public static ProcessHandler findRunningConsole(Project project, @NotNull NotNullFunction<String, Boolean> cmdLineMatcher) {
        ProcessHandler[] processes;
        if (cmdLineMatcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionHelper.findRunningConsole must not be null");
        }
        for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            String commandLine;
            if (!(process instanceof OSProcessHandler) || process.isProcessTerminated() || !((Boolean)cmdLineMatcher.fun((Object)(commandLine = ((OSProcessHandler)process).getCommandLine()))).booleanValue()) continue;
            return process;
        }
        return null;
    }

    public static void executeExternalProcess(@Nullable Project myProject, final @NotNull OSProcessHandler processHandler, @NotNull ExecutionMode mode) {
        String title;
        if (processHandler == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionHelper.executeExternalProcess must not be null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutionHelper.executeExternalProcess must not be null");
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : "Running. Please wait...";
        assert (title != null);
        final Runnable process = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess((ProcessHandler)processHandler, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? new Runnable(){

            @Override
            public void run() {
                processHandler.waitFor();
            }
        } : ExecutionHelper.createTimelimitedExecutionProcess(processHandler, mode.getTimeout()));
        if (mode.withModalProgress()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutionHelper$4.run must not be null");
                    }
                    process.run();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final ProcessHandler processHandler, final Function<Object, Boolean> cancelableFun) {
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        processHandler.waitFor();
                    }
                    finally {
                        mySemaphore.up();
                    }
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && ((Boolean)cancelableFun.fun(null)).booleanValue() || processHandler.isProcessTerminated()) {
                            if (processHandler.isProcessTerminated()) break;
                            try {
                                processHandler.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText("Please wait");
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimelimitedExecutionProcess(final OSProcessHandler processHandler, final int timeout) {
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Object LOCK = new Object();
            private Boolean processedFinished = Boolean.FALSE;
            private final Runnable myProcessThread = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        processHandler.waitFor();
                        Object object = LOCK;
                        synchronized (object) {
                            processedFinished = Boolean.TRUE;
                        }
                    }
                    finally {
                        mySemaphore.up();
                    }
                }
            };
            private final Runnable myTimeoutListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(1000 * timeout);
                                Object object = LOCK;
                                synchronized (object) {
                                    if (!processedFinished.booleanValue()) {
                                        LOG.error("Timeout (" + timeout + " sec) on executing: " + processHandler.getCommandLine());
                                        processHandler.destroyProcess();
                                    }
                                }
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myTimeoutListener);
                this.mySemaphore.waitFor();
            }
        };
    }

    public static class RailsErrorViewPanel
    extends NewErrorTreeViewPanel {
        public RailsErrorViewPanel(Project project) {
            super(project, null);
        }

        @Override
        protected boolean canHideWarnings() {
            return false;
        }
    }
}

