/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class VMOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.VMOptions");
    @NonNls
    public static final String XMX_OPTION_NAME = "Xmx";
    @NonNls
    public static final String PERM_GEN_OPTION_NAME = "XX:MaxPermSize";
    @NonNls
    private static final String XMX_OPTION = "-Xmx";
    @NonNls
    private static final String PERM_GEN_OPTION = "-XX:MaxPermSize=";
    @NonNls
    private static final String MEM_SIZE_EXPR = "(\\d*)([a-zA-Z]*)";
    @NonNls
    private static final Pattern XMX_PATTERN = Pattern.compile("-Xmx(\\d*)([a-zA-Z]*)");
    @NonNls
    private static final Pattern PERM_GEN_PATTERN = Pattern.compile("-XX:MaxPermSize=(\\d*)([a-zA-Z]*)");
    @NonNls
    private static final Pattern MAC_OS_VM_OPTIONS_PATTERN = Pattern.compile("(<key>VMOptions</key>(?:(?:\\s*)(?:<!--(?:.*)-->(?:\\s*))*)<string>)(.*)(</string>)");
    @NonNls
    private static final String INFO_PLIST = "/Contents/Info.plist";
    private static String ourTestPath;
    private static boolean ourTestMacOs;

    public static void setTestFile(String path, boolean isMacOs) {
        ourTestPath = path;
        ourTestMacOs = isMacOs;
    }

    public static void clearTestFile() {
        ourTestPath = null;
    }

    public static int readXmx() {
        return VMOptions.readOption(XMX_PATTERN);
    }

    public static void writeXmx(int value) {
        VMOptions.writeOption(XMX_OPTION, value, XMX_PATTERN);
    }

    public static int readMaxPermGen() {
        return VMOptions.readOption(PERM_GEN_PATTERN);
    }

    public static void writeMaxPermGen(int value) {
        VMOptions.writeOption(PERM_GEN_OPTION, value, PERM_GEN_PATTERN);
    }

    private static int readOption(Pattern pattern) {
        try {
            String content = new String(FileUtil.loadFileText((File)VMOptions.getFile()));
            if (VMOptions.isMacOs() && (content = VMOptions.extractMacOsVMOptionsSection(content)) == null) {
                return -1;
            }
            Matcher m = pattern.matcher(content);
            if (!m.find()) {
                return -1;
            }
            String valueString = m.group(1);
            String unitString = m.group(2);
            try {
                int value = Integer.parseInt(valueString);
                double multiplier = VMOptions.parseUnit(unitString);
                return (int)((double)value * multiplier);
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
                return -1;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    private static double parseUnit(String unitString) {
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"k")) {
            return 9.765625E-4;
        }
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"g")) {
            return 1024.0;
        }
        return 1.0;
    }

    private static void writeOption(String option, int value, Pattern pattern) {
        try {
            String vmOptions;
            String optionValue = option + value + "m";
            String content = new String(FileUtil.loadFileText((File)VMOptions.getFile()));
            if (VMOptions.isMacOs()) {
                vmOptions = VMOptions.extractMacOsVMOptions(content);
                if (vmOptions == null) {
                    return;
                }
            } else {
                vmOptions = content;
            }
            vmOptions = VMOptions.replace(pattern, vmOptions, optionValue, "", "", vmOptions + " " + optionValue);
            content = VMOptions.isMacOs() ? VMOptions.replace(MAC_OS_VM_OPTIONS_PATTERN, content, vmOptions, "$1", "$3", content) : vmOptions;
            FileUtil.setReadOnlyAttribute((String)VMOptions.getFile().getPath(), (boolean)false);
            FileUtil.writeToFile((File)VMOptions.getFile(), (byte[])content.getBytes());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static String extractMacOsVMOptionsSection(String text) {
        Matcher m = MAC_OS_VM_OPTIONS_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group();
    }

    private static String extractMacOsVMOptions(String text) {
        Matcher m = MAC_OS_VM_OPTIONS_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group(2);
    }

    private static String replace(Pattern pattern, String text, String replacement, String prefix, String suffix, String defaultResult) {
        Matcher m = pattern.matcher(text);
        if (!m.find()) {
            return defaultResult;
        }
        StringBuffer b = new StringBuffer();
        m.appendReplacement(b, prefix + Matcher.quoteReplacement(replacement) + suffix);
        m.appendTail(b);
        return b.toString();
    }

    private static File getFile() {
        if (ourTestPath != null) {
            return new File(ourTestPath);
        }
        return new File(VMOptions.getSettingsFilePath());
    }

    @NonNls
    public static String getSettingsFilePath() {
        String productName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase();
        if (SystemInfo.isMac) {
            return PathManager.getHomePath() + INFO_PLIST;
        }
        if (SystemInfo.isWindows) {
            return PathManager.getBinPath() + File.separatorChar + productName + ".exe.vmoptions";
        }
        return PathManager.getBinPath() + File.separatorChar + productName + ".vmoptions";
    }

    private static boolean isMacOs() {
        if (ourTestPath != null) {
            return ourTestMacOs;
        }
        return SystemInfo.isMac;
    }
}

