/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueMarkup {
    public static final long AUTO_MARKUP_REFERRING_OBJECTS_LIMIT = 100L;
    private final String myText;
    private final Color myColor;
    @Nullable
    private final String myToolTipText;

    public ValueMarkup(String text, Color color) {
        this(text, color, null);
    }

    public ValueMarkup(String text, Color color, String toolTipText) {
        this.myText = text;
        this.myColor = color;
        this.myToolTipText = toolTipText;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/tree/ValueMarkup.getText must not return null");
        }
        return string;
    }

    public Color getColor() {
        return this.myColor;
    }

    @Nullable
    public String getToolTipText() {
        return this.myToolTipText;
    }

    public static Color getAutoMarkupColor() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = manager.getGlobalScheme().getAttributes(HighlightInfoType.STATIC_FIELD.getAttributesKey());
        return textAttributes.getForegroundColor();
    }
}

