/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.actions.AddAction;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.debugger.ui.breakpoints.actions.GotoSourceAction;
import com.intellij.debugger.ui.breakpoints.actions.RemoveAction;
import com.intellij.debugger.ui.breakpoints.actions.SwitchViewAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleFlattenPackagesAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleGroupByClassesAction;
import com.intellij.debugger.ui.breakpoints.actions.ViewSourceAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.jdom.Element;

public class FieldBreakpointFactory
extends BreakpointFactory {
    @Override
    public Breakpoint createBreakpoint(Project project, Element element) {
        return new FieldBreakpoint(project);
    }

    @Override
    public Icon getIcon() {
        return FieldBreakpoint.ICON;
    }

    @Override
    public Icon getDisabledIcon() {
        return FieldBreakpoint.DISABLED_ICON;
    }

    @Override
    public BreakpointPanel createBreakpointPanel(Project project, final DialogWrapper parentDialog) {
        BreakpointPanel panel = new BreakpointPanel(project, new FieldBreakpointPropertiesPanel(project), new BreakpointPanelAction[]{new SwitchViewAction(), new AddFieldBreakpointAction(project), new GotoSourceAction(project){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                parentDialog.close(0);
            }
        }, new ViewSourceAction(project), new RemoveAction(project), new ToggleGroupByClassesAction(), new ToggleFlattenPackagesAction()}, this.getBreakpointCategory(), DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]), "debugging.fieldWatchpoint");
        panel.getTree().setGroupByMethods(false);
        return panel;
    }

    public Key<FieldBreakpoint> getBreakpointCategory() {
        return FieldBreakpoint.CATEGORY;
    }

    private static class AddFieldBreakpointAction
    extends AddAction {
        private final Project myProject;

        public AddFieldBreakpointAction(Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(this.myProject){

                @Override
                protected boolean validateData() {
                    String className = this.getClassName();
                    if (className.length() == 0) {
                        Messages.showMessageDialog((Project)AddFieldBreakpointAction.this.myProject, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                        return false;
                    }
                    String fieldName = this.getFieldName();
                    if (fieldName.length() == 0) {
                        Messages.showMessageDialog((Project)AddFieldBreakpointAction.this.myProject, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                        return false;
                    }
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)AddFieldBreakpointAction.this.myProject).findClass(className, GlobalSearchScope.allScope((Project)AddFieldBreakpointAction.this.myProject));
                    if (psiClass != null) {
                        PsiFile psiFile = psiClass.getContainingFile();
                        Document document = PsiDocumentManager.getInstance((Project)AddFieldBreakpointAction.this.myProject).getDocument(psiFile);
                        if (document != null) {
                            PsiField field = psiClass.findFieldByName(fieldName, true);
                            if (field != null) {
                                int line = document.getLineNumber(field.getTextOffset());
                                FieldBreakpoint fieldBreakpoint = DebuggerManagerEx.getInstanceEx(AddFieldBreakpointAction.this.myProject).getBreakpointManager().addFieldBreakpoint(document, line, fieldName);
                                if (fieldBreakpoint != null) {
                                    AddFieldBreakpointAction.this.getPanel().addBreakpoint(fieldBreakpoint);
                                    return true;
                                }
                            } else {
                                Messages.showMessageDialog((Project)AddFieldBreakpointAction.this.myProject, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className, fieldName, fieldName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                            }
                        }
                    } else {
                        Messages.showMessageDialog((Project)AddFieldBreakpointAction.this.myProject, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{className, fieldName, className}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    }
                    return false;
                }
            };
            dialog.show();
        }
    }
}

