/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointNameCellRenderer;
import com.intellij.debugger.ui.breakpoints.BreakpointTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BreakpointTable
extends Table {
    public BreakpointTable(Project project) {
        super((TableModel)new BreakpointTableModel(project));
        this.setColumnSelectionAllowed(false);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        Object o = inputMap.get(KeyStroke.getKeyStroke(32, 0));
        if (o == null) {
            o = "enable_disable";
            inputMap.put(KeyStroke.getKeyStroke(32, 0), o);
        }
        actionMap.put(o, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BreakpointTable.this.isEditing()) {
                    return;
                }
                int[] indices = BreakpointTable.this.getSelectedRows();
                boolean currentlyMarked = true;
                for (int i = 0; i < indices.length; ++i) {
                    Boolean isMarked = (Boolean)BreakpointTable.this.getValueAt(indices[i], 0);
                    boolean bl = currentlyMarked = isMarked != null ? isMarked : false;
                    if (!currentlyMarked) break;
                }
                Boolean valueToSet = currentlyMarked ? Boolean.FALSE : Boolean.TRUE;
                for (int i = 0; i < indices.length; ++i) {
                    BreakpointTable.this.setValueAt(valueToSet, indices[i], 0);
                }
            }
        });
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setColumnSelectionAllowed(false);
        int width = new JCheckBox().getPreferredSize().width;
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn enabledStateColumn = columnModel.getColumn(0);
        enabledStateColumn.setPreferredWidth(width);
        enabledStateColumn.setMaxWidth(width);
        Class enabledStateColumnClass = this.getModel().getColumnClass(0);
        final TableCellRenderer delegateRenderer = this.getDefaultRenderer(enabledStateColumnClass);
        this.setDefaultRenderer(enabledStateColumnClass, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(null);
                }
                return component;
            }
        });
        columnModel.getColumn(1).setCellRenderer(new BreakpointNameCellRenderer());
    }

    public BreakpointTableModel getModel() {
        return (BreakpointTableModel)super.getModel();
    }

    public void setBreakpoints(Breakpoint[] breakpoints) {
        this.getModel().setBreakpoints(breakpoints);
    }

    public final List<Breakpoint> getBreakpoints() {
        return this.getModel().getBreakpoints();
    }

    public Breakpoint[] getSelectedBreakpoints() {
        if (this.getRowCount() == 0) {
            return Breakpoint.EMPTY_ARRAY;
        }
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return Breakpoint.EMPTY_ARRAY;
        }
        Breakpoint[] rv = new Breakpoint[rows.length];
        for (int idx = 0; idx < rows.length; ++idx) {
            rv[idx] = this.getModel().getBreakpoint(rows[idx]);
        }
        return rv;
    }
}

