/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointTableModel;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BreakpointNameCellRenderer
extends DefaultTableCellRenderer {
    private final Color myAnyExceptionForeground = new Color(128, 0, 0);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(null);
        BreakpointTableModel tableModel = (BreakpointTableModel)table.getModel();
        Breakpoint breakpoint = tableModel.getBreakpoint(row);
        if (breakpoint == null) {
            return this;
        }
        Icon icon = breakpoint instanceof BreakpointWithHighlighter ? (breakpoint.ENABLED ? ((BreakpointWithHighlighter)breakpoint).getSetIcon(false) : ((BreakpointWithHighlighter)breakpoint).getDisabledIcon(false)) : breakpoint.getIcon();
        this.setIcon(icon);
        this.setDisabledIcon(icon);
        if (isSelected) {
            this.setForeground(UIUtil.getTableSelectionForeground());
        } else {
            Color foreColor = breakpoint instanceof AnyExceptionBreakpoint ? this.myAnyExceptionForeground : UIUtil.getTableForeground();
            this.setForeground(foreColor);
        }
        this.setEnabled(breakpoint.ENABLED);
        return this;
    }
}

