/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.ValueHintTreeComponent;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHintTreeComponent;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHint");
    private PsiExpression myCurrentExpression = null;

    private ValueHint(Project project, Editor editor, Point point, ValueHintType type, PsiExpression selectedExpression, TextRange textRange) {
        super(project, editor, point, type, textRange);
        this.myCurrentExpression = selectedExpression;
    }

    public static ValueHint createValueHint(Project project, Editor editor, Point point, ValueHintType type) {
        Pair<PsiExpression, TextRange> pair = ValueHint.getSelectedExpression(project, editor, point, type);
        return new ValueHint(project, editor, point, type, (PsiExpression)pair.getFirst(), (TextRange)pair.getSecond());
    }

    @Override
    protected boolean canShowHint() {
        return this.myCurrentExpression != null;
    }

    @Override
    protected void evaluateAndShowHint() {
        final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || !debuggerSession.isPaused()) {
            return;
        }
        try {
            final ExpressionEvaluator evaluator = EvaluatorBuilderImpl.getInstance().build((PsiElement)this.myCurrentExpression, debuggerContext.getSourcePosition());
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction() {
                    try {
                        EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
                        TextWithImportsImpl text = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ValueHint.this.myCurrentExpression.getText());
                        final Value value = evaluator.evaluate(evaluationContext);
                        final WatchItemDescriptor descriptor = new WatchItemDescriptor(ValueHint.this.getProject(), text, value);
                        if (!ValueHint.isActiveTootlipApplicable(value) || ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                            descriptor.setContext(evaluationContext);
                            if (ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                descriptor.setRenderer(debuggerContext.getDebugProcess().getDefaultRenderer(value));
                            }
                            descriptor.updateRepresentation(evaluationContext, new DescriptorLabelListener(){

                                @Override
                                public void labelChanged() {
                                    if (ValueHint.this.getCurrentRange() != null && (ValueHint.this.getType() != ValueHintType.MOUSE_OVER_HINT || descriptor.isValueValid())) {
                                        SimpleColoredText simpleColoredText = DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, true);
                                        if (ValueHint.isActiveTootlipApplicable(value)) {
                                            simpleColoredText.append(" (" + DebuggerBundle.message((String)"active.tooltip.suggestion", (Object[])new Object[0]) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                        }
                                        ValueHint.this.showHint(simpleColoredText, descriptor);
                                    }
                                }
                            });
                        } else {
                            InspectDebuggerTree tree = ValueHint.this.getInspectTree(descriptor);
                            ValueHint.this.showTreePopup(tree, debuggerContext, ValueHint.this.myCurrentExpression.getText(), new ValueHintTreeComponent(ValueHint.this, tree, ValueHint.this.myCurrentExpression.getText()));
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            });
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static boolean isActiveTootlipApplicable(Value value) {
        return value != null && !(value instanceof PrimitiveValue);
    }

    public void showTreePopup(final InspectDebuggerTree tree, final DebuggerContextImpl debuggerContext, final String title, final AbstractValueHintTreeComponent<?> component) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                tree.rebuild(debuggerContext);
                ValueHint.this.showTreePopup(component, tree, title);
            }
        });
    }

    private void showHint(final SimpleColoredText text, final WatchItemDescriptor descriptor) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                if (!ValueHint.this.isHintHidden()) {
                    JComponent component = !ValueHint.isActiveTootlipApplicable(descriptor.getValue()) ? HintUtil.createInformationLabel(text) : ValueHint.this.createExpandableHintComponent(text, new Runnable(){

                        @Override
                        public void run() {
                            final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(ValueHint.this.getProject()).getContext();
                            final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
                            debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                                @Override
                                public void threadAction() {
                                    descriptor.setRenderer(debugProcess.getAutoRenderer(descriptor));
                                    InspectDebuggerTree tree = ValueHint.this.getInspectTree(descriptor);
                                    ValueHint.this.showTreePopup(tree, debuggerContext, ValueHint.this.myCurrentExpression.getText(), new ValueHintTreeComponent(ValueHint.this, tree, ValueHint.this.myCurrentExpression.getText()));
                                }
                            });
                        }
                    });
                    if (!ValueHint.this.showHint(component)) {
                        return;
                    }
                    if (ValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                        HintUtil.createInformationLabel(text).requestFocusInWindow();
                    }
                }
            }
        });
    }

    private InspectDebuggerTree getInspectTree(WatchItemDescriptor descriptor) {
        InspectDebuggerTree tree = new InspectDebuggerTree(this.getProject());
        tree.getModel().addTreeModelListener(this.createTreeListener(tree));
        tree.setInspectDescriptor(descriptor);
        return tree;
    }

    private static boolean canProcess(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)expression).getQualifierExpression();
            return qualifier == null || ValueHint.canProcess(qualifier);
        }
        return !(expression instanceof PsiMethodCallExpression);
    }

    @Nullable
    private static Pair<PsiExpression, TextRange> findExpression(PsiElement element) {
        if (!(element instanceof PsiIdentifier) && !(element instanceof PsiKeyword)) {
            return null;
        }
        PsiElement expression = null;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            expression = element;
        } else if (parent instanceof PsiReferenceExpression && ValueHint.canProcess((PsiExpression)parent)) {
            expression = parent;
        }
        if (parent instanceof PsiThisExpression) {
            expression = parent;
        }
        try {
            if (expression != null) {
                PsiElement context;
                if (parent instanceof PsiParameter) {
                    try {
                        context = ((PsiMethod)((PsiParameter)parent).getDeclarationScope()).getBody();
                    }
                    catch (Throwable e) {}
                } else {
                    for (context = element; context != null && !(context instanceof PsiStatement) && !(context instanceof PsiClass); context = context.getParent()) {
                    }
                }
                TextRange textRange = expression.getTextRange();
                PsiExpression psiExpression = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createExpressionFromText(expression.getText(), context);
                return Pair.create((Object)psiExpression, (Object)textRange);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    private static Pair<PsiExpression, TextRange> getSelectedExpression(final Project project, final Editor editor, final Point point, final ValueHintType type) {
        final Ref selectedExpression = Ref.create(null);
        final Ref currentRange = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                int offset = AbstractValueHint.calculateOffset(editor, point);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (psiFile == null || !psiFile.isValid()) {
                    return;
                }
                int selectionStart = editor.getSelectionModel().getSelectionStart();
                int selectionEnd = editor.getSelectionModel().getSelectionEnd();
                if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionStart <= offset && offset <= selectionEnd) {
                    PsiElement ctx = selectionStart > 0 ? psiFile.findElementAt(selectionStart - 1) : psiFile.findElementAt(selectionStart);
                    try {
                        String text = editor.getSelectionModel().getSelectedText();
                        if (text != null && ctx != null) {
                            selectedExpression.set((Object)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(text, ctx));
                            currentRange.set((Object)new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()));
                        }
                    }
                    catch (IncorrectOperationException e) {
                        // empty catch block
                    }
                }
                if (currentRange.get() == null) {
                    PsiElement elementAtCursor = psiFile.findElementAt(offset);
                    if (elementAtCursor == null) {
                        return;
                    }
                    Pair pair = ValueHint.findExpression(elementAtCursor);
                    if (pair == null) {
                        return;
                    }
                    selectedExpression.set(pair.getFirst());
                    currentRange.set(pair.getSecond());
                }
            }
        });
        return Pair.create((Object)selectedExpression.get(), (Object)currentRange.get());
    }
}

