/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapUIImpl
extends HotSwapUI
implements ProjectComponent {
    private final List<HotSwapVetoableListener> myListeners = ContainerUtil.createEmptyCOWList();
    private boolean myAskBeforeHotswap = true;
    private final Project myProject;
    private boolean myPerformHotswapAfterThisCompilation = true;

    public HotSwapUIImpl(Project project, MessageBus bus) {
        this.myProject = project;
        bus.connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (HotSwapUIImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (errors == 0 && !aborted && HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation) {
                    for (HotSwapVetoableListener listener : HotSwapUIImpl.this.myListeners) {
                        if (listener.shouldHotSwap(compileContext)) continue;
                        return;
                    }
                    ArrayList<DebuggerSession> sessions = new ArrayList<DebuggerSession>();
                    Collection<DebuggerSession> debuggerSessions = DebuggerManagerEx.getInstanceEx(HotSwapUIImpl.this.myProject).getSessions();
                    for (DebuggerSession debuggerSession : debuggerSessions) {
                        if (!debuggerSession.isAttached() || !debuggerSession.getProcess().canRedefineClasses()) continue;
                        sessions.add(debuggerSession);
                    }
                    if (sessions.size() > 0) {
                        HotSwapUIImpl.this.hotSwapSessions(sessions);
                    }
                }
                HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation = true;
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("HotSwapUI" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/HotSwapUIImpl.getComponentName must not return null");
        }
        return "HotSwapUI";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Override
    public void addListener(HotSwapVetoableListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(HotSwapVetoableListener listener) {
        this.myListeners.remove(listener);
    }

    private void hotSwapSessions(final List<DebuggerSession> sessions) {
        final boolean shouldAskBeforeHotswap = this.myAskBeforeHotswap;
        this.myAskBeforeHotswap = true;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final String runHotswap = DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE;
        if (shouldAskBeforeHotswap && "RunHotswapNever".equals(runHotswap)) {
            return;
        }
        final HotSwapProgressImpl findClassesProgress = new HotSwapProgressImpl(this.myProject);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final Map modifiedClasses = HotSwapUIImpl.getModifiedClasses(findClassesProgress, sessions);
                final Application application = ApplicationManager.getApplication();
                if (modifiedClasses.isEmpty()) {
                    application.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = DebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                            ToolWindowManager.getInstance((Project)HotSwapUIImpl.this.myProject).notifyByBalloon(ToolWindowId.DEBUG, MessageType.INFO, message, null, null);
                            WindowManager.getInstance().getStatusBar(HotSwapUIImpl.this.myProject).setInfo(message);
                        }
                    }, ModalityState.NON_MODAL);
                    return;
                }
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (shouldAskBeforeHotswap && !"RunHotswapAlways".equals(runHotswap)) {
                            RunHotswapDialog dialog = new RunHotswapDialog(HotSwapUIImpl.this.myProject, sessions);
                            dialog.show();
                            if (!dialog.isOK()) {
                                return;
                            }
                            modifiedClasses.keySet().retainAll(dialog.getSessionsToReload());
                        }
                        if (modifiedClasses.size() > 0) {
                            final HotSwapProgressImpl progress = new HotSwapProgressImpl(HotSwapUIImpl.this.myProject);
                            application.executeOnPooledThread(new Runnable(){

                                @Override
                                public void run() {
                                    HotSwapUIImpl.reloadModifiedClasses(modifiedClasses, progress);
                                }
                            });
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    private static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgressImpl progress) {
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                HotSwapManager.reloadModifiedClasses(modifiedClasses, progress);
                progress.finished();
            }
        }, progress.getProgressIndicator());
    }

    private static Map<DebuggerSession, Map<String, HotSwapFile>> getModifiedClasses(final HotSwapProgressImpl swapProgress, final List<DebuggerSession> sessions) {
        final Ref modifiedClasses = Ref.create(null);
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                modifiedClasses.set(HotSwapManager.getModifiedClasses(sessions, swapProgress));
                swapProgress.finished();
            }
        }, swapProgress.getProgressIndicator());
        return (Map)modifiedClasses.get();
    }

    @Override
    public void reloadChangedClasses(DebuggerSession session, boolean compileBeforeHotswap) {
        this.dontAskHotswapAfterThisCompilation();
        if (compileBeforeHotswap) {
            CompilerManager.getInstance((Project)session.getProject()).make(null);
        } else if (session.isAttached()) {
            ArrayList<DebuggerSession> sessions = new ArrayList<DebuggerSession>(1);
            sessions.add(session);
            this.hotSwapSessions(sessions);
        }
    }

    @Override
    public void dontPerformHotswapAfterThisCompilation() {
        this.myPerformHotswapAfterThisCompilation = false;
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.myAskBeforeHotswap = false;
    }
}

