/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.StateRestoringCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class DebuggerLaunchingConfigurable
implements Configurable {
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private JCheckBox myHideDebuggerCheckBox;
    private StateRestoringCheckBox myCbForceClassicVM;
    private JCheckBox myCbDisableJIT;

    public void reset() {
        DebuggerSettings settings = DebuggerSettings.getInstance();
        if (!SystemInfo.isWindows) {
            this.myRbSocket.setSelected(true);
            this.myRbShmem.setEnabled(false);
        } else {
            if (settings.DEBUGGER_TRANSPORT == 1) {
                this.myRbShmem.setSelected(true);
            } else {
                this.myRbSocket.setSelected(true);
            }
            this.myRbShmem.setEnabled(true);
        }
        this.myHideDebuggerCheckBox.setSelected(settings.HIDE_DEBUGGER_ON_PROCESS_TERMINATION);
        this.myCbForceClassicVM.setSelected(settings.FORCE_CLASSIC_VM);
        this.myCbDisableJIT.setSelected(settings.DISABLE_JIT);
    }

    public void apply() {
        this.getSettingsTo(DebuggerSettings.getInstance());
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.DEBUGGER_TRANSPORT = this.myRbShmem.isSelected() ? 1 : 0;
        settings.HIDE_DEBUGGER_ON_PROCESS_TERMINATION = this.myHideDebuggerCheckBox.isSelected();
        settings.FORCE_CLASSIC_VM = this.myCbForceClassicVM.isSelectedWhenSelectable();
        settings.DISABLE_JIT = this.myCbDisableJIT.isSelected();
    }

    public boolean isModified() {
        DebuggerSettings currentSettings = DebuggerSettings.getInstance();
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"debugger.launching.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.launching";
    }

    public JComponent createComponent() {
        Insets insets;
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbForceClassicVM = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.debugger.launching.configurable.force.classic.vm", (Object[])new Object[0]));
        this.myCbDisableJIT = new JCheckBox(DebuggerBundle.message((String)"label.debugger.launching.configurable.disable.jit", (Object[])new Object[0]));
        this.myHideDebuggerCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.debugger.launching.configurable.hide.window", (Object[])new Object[0]));
        this.myRbSocket = new JRadioButton(DebuggerBundle.message((String)"label.debugger.launching.configurable.socket", (Object[])new Object[0]));
        this.myRbShmem = new JRadioButton(DebuggerBundle.message((String)"label.debugger.launching.configurable.shmem", (Object[])new Object[0]));
        int cbLeftOffset = 0;
        Border border = this.myCbForceClassicVM.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.myCbForceClassicVM)) != null) {
            cbLeftOffset = insets.left;
        }
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myRbSocket);
        gr.add(this.myRbShmem);
        Box box = Box.createHorizontalBox();
        box.add(this.myRbSocket);
        box.add(this.myRbShmem);
        JPanel transportPanel = new JPanel(new BorderLayout());
        transportPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.debugger.launching.configurable.debugger.transport", (Object[])new Object[0])), "West");
        transportPanel.add((Component)box, "Center");
        panel.add((Component)transportPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, cbLeftOffset, 0, 0), 0, 0));
        panel.add((Component)this.myCbForceClassicVM, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbDisableJIT, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myHideDebuggerCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        return panel;
    }

    public void disposeUIResources() {
    }
}

