/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.debugger.ui.DebuggerSessionTab;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ThreadDumpAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        if (context.getDebuggerSession() != null) {
            final DebugProcessImpl process = context.getDebugProcess();
            process.getManagerThread().invoke(new DebuggerCommandImpl(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void action() throws Exception {
                    VirtualMachineProxyImpl vm = process.getVirtualMachineProxy();
                    vm.suspend();
                    try {
                        final List threads = ThreadDumpAction.buildThreadStates(vm);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DebuggerSessionTab sessionTab = DebuggerPanelsManager.getInstance(project).getSessionTab();
                                if (sessionTab != null) {
                                    sessionTab.addThreadDump(threads);
                                }
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    finally {
                        vm.resume();
                    }
                }
            });
        }
    }

    private static List<ThreadState> buildThreadStates(VirtualMachineProxyImpl vmProxy) {
        List<ThreadReference> threads = vmProxy.getVirtualMachine().allThreads();
        ArrayList<ThreadState> result = new ArrayList<ThreadState>();
        HashMap<String, ThreadState> nameToThreadMap = new HashMap<String, ThreadState>();
        HashMap<String, String> waitingMap = new HashMap<String, String>();
        for (ThreadReference threadReference : threads) {
            ThreadGroupReference groupReference;
            StringBuilder buffer = new StringBuilder();
            boolean hasEmptyStack = true;
            int threadStatus = threadReference.status();
            if (threadStatus == 0) continue;
            String threadName = ThreadDumpAction.threadName(threadReference);
            ThreadState threadState = new ThreadState(threadName, ThreadDumpAction.threadStatusToState(threadStatus));
            nameToThreadMap.put(threadName, threadState);
            result.add(threadState);
            threadState.setJavaThreadState(ThreadDumpAction.threadStatusToJavaThreadState(threadStatus));
            buffer.append(threadName);
            ReferenceType referenceType = threadReference.referenceType();
            if (referenceType != null) {
                Value value;
                Field priority;
                Value value2;
                Field daemon = referenceType.fieldByName("daemon");
                if (daemon != null && (value2 = threadReference.getValue(daemon)) instanceof BooleanValue && ((BooleanValue)value2).booleanValue()) {
                    buffer.append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                    threadState.setDaemon(true);
                }
                if ((priority = referenceType.fieldByName("priority")) != null && (value = threadReference.getValue(priority)) instanceof IntegerValue) {
                    buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)value).intValue()}));
                }
            }
            if ((groupReference = threadReference.threadGroup()) != null) {
                buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.group", (Object[])new Object[]{groupReference.name()}));
            }
            buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.status", (Object[])new Object[]{threadState.getState()}));
            buffer.append("\n  java.lang.Thread.State: ").append(threadState.getJavaThreadState());
            try {
                List<StackFrame> frames;
                ThreadReference waitedMonitorOwner;
                ObjectReference waitedMonitor;
                if (vmProxy.canGetOwnedMonitorInfo() && vmProxy.canGetMonitorInfo()) {
                    List<ObjectReference> list = threadReference.ownedMonitors();
                    for (ObjectReference reference : list) {
                        List<ThreadReference> waiting = reference.waitingThreads();
                        for (ThreadReference thread : waiting) {
                            String waitingThreadName = ThreadDumpAction.threadName(thread);
                            waitingMap.put(waitingThreadName, threadName);
                            buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{waitingThreadName}));
                        }
                    }
                }
                ObjectReference objectReference = waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? threadReference.currentContendedMonitor() : null;
                if (waitedMonitor != null && vmProxy.canGetMonitorInfo() && (waitedMonitorOwner = waitedMonitor.owningThread()) != null) {
                    String monitorOwningThreadName = ThreadDumpAction.threadName(waitedMonitorOwner);
                    waitingMap.put(threadName, monitorOwningThreadName);
                    buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{monitorOwningThreadName}));
                }
                hasEmptyStack = (frames = threadReference.frames()).size() == 0;
                for (StackFrame stackFrame : frames) {
                    Location location = stackFrame.location();
                    buffer.append("\n\t  ").append(ThreadDumpAction.renderLocation(location));
                }
            }
            catch (IncompatibleThreadStateException e) {
                buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            threadState.setStackTrace(buffer.toString(), hasEmptyStack);
            ThreadDumpParser.inferThreadStateDetail(threadState);
        }
        for (String waiting : waitingMap.keySet()) {
            ThreadState waitingThread = (ThreadState)nameToThreadMap.get(waiting);
            ThreadState awaitedThread = (ThreadState)nameToThreadMap.get(waitingMap.get(waiting));
            awaitedThread.addWaitingThread(waitingThread);
        }
        for (ThreadState thread : result) {
            for (ThreadState awaitingThread : thread.getAwaitingThreads()) {
                if (!awaitingThread.isAwaitedBy(thread)) continue;
                thread.addDeadlockedThread(awaitingThread);
                awaitingThread.addDeadlockedThread(thread);
            }
        }
        ThreadDumpParser.sortThreads(result);
        return result;
    }

    private static String threadStatusToJavaThreadState(int status) {
        switch (status) {
            case 3: {
                return Thread.State.BLOCKED.name();
            }
            case 5: {
                return Thread.State.NEW.name();
            }
            case 1: {
                return Thread.State.RUNNABLE.name();
            }
            case 2: {
                return Thread.State.TIMED_WAITING.name();
            }
            case 4: {
                return Thread.State.WAITING.name();
            }
            case 0: {
                return Thread.State.TERMINATED.name();
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    private static String threadStatusToState(int status) {
        switch (status) {
            case 3: {
                return "waiting for monitor entry";
            }
            case 5: {
                return "not started";
            }
            case 1: {
                return "runnable";
            }
            case 2: {
                return "sleeping";
            }
            case 4: {
                return "waiting";
            }
            case 0: {
                return "zombie";
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    private static String renderLocation(Location location) {
        String sourceName;
        try {
            sourceName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            sourceName = "Unknown Source";
        }
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{location.declaringType().name() + "." + location.method().name(), sourceName, location.lineNumber()});
    }

    private static String threadName(ThreadReference threadReference) {
        return threadReference.name() + "@" + threadReference.uniqueID();
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null);
    }
}

