/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.PsiMethodListPopupStep;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartStepIntoActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/SmartStepIntoActionHandler.perform must not be null");
        }
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
        SmartStepIntoActionHandler.doStep(project, debuggerContext.getSourcePosition(), debuggerContext.getDebuggerSession());
    }

    private static void doStep(@NotNull Project project, @Nullable SourcePosition position, final @NotNull DebuggerSession session) {
        List<PsiMethod> methods;
        FileEditor fileEditor;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/SmartStepIntoActionHandler.doStep must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/actions/SmartStepIntoActionHandler.doStep must not be null");
        }
        VirtualFile file = position != null ? position.getFile().getVirtualFile() : null;
        FileEditor fileEditor2 = fileEditor = file != null ? FileEditorManager.getInstance((Project)project).getSelectedEditor(file) : null;
        if (fileEditor instanceof TextEditor && (methods = SmartStepIntoActionHandler.findReferencedMethods(position)).size() > 0) {
            if (methods.size() == 1) {
                session.stepInto(true, SmartStepIntoActionHandler.createSmartStepFilter(methods.get(0)));
            } else {
                PsiMethodListPopupStep popupStep = new PsiMethodListPopupStep(methods, new PsiMethodListPopupStep.OnChooseRunnable(){

                    @Override
                    public void execute(PsiMethod chosenMethod) {
                        session.stepInto(true, SmartStepIntoActionHandler.createSmartStepFilter(chosenMethod));
                    }
                });
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
                RelativePoint point = DebuggerUIUtil.calcPopupLocation(((TextEditor)fileEditor).getEditor(), position.getLine());
                popup.show(point);
            }
            return;
        }
        session.stepInto(true, null);
    }

    @Nullable
    private static RequestHint.SmartStepFilter createSmartStepFilter(PsiMethod method) {
        return new RequestHint.SmartStepFilter(method);
    }

    private static List<PsiMethod> findReferencedMethods(SourcePosition position) {
        int line = position.getLine();
        if (line < 0) {
            return Collections.emptyList();
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return Collections.emptyList();
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        int startOffset = doc.getLineStartOffset(line);
        final TextRange lineRange = new TextRange(startOffset, doc.getLineEndOffset(line));
        int offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)startOffset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            OrderedSet methods = new OrderedSet(TObjectHashingStrategy.CANONICAL);
            JavaRecursiveElementWalkingVisitor methodCollector = new JavaRecursiveElementWalkingVisitor((List)methods){
                final /* synthetic */ List val$methods;
                {
                    this.val$methods = list;
                }

                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                }

                public void visitStatement(PsiStatement statement) {
                    if (lineRange.intersects(statement.getTextRange())) {
                        super.visitStatement(statement);
                    }
                }

                public void visitCallExpression(PsiCallExpression expression) {
                    PsiMethod psiMethod = expression.resolveMethod();
                    if (psiMethod != null) {
                        this.val$methods.add(psiMethod);
                    }
                    super.visitCallExpression(expression);
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            return methods;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/SmartStepIntoActionHandler.isEnabled must not be null");
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        boolean isPaused = debuggerSession != null && debuggerSession.isPaused();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        boolean hasCurrentThread = suspendContext != null && suspendContext.getThread() != null;
        return isPaused && hasCurrentThread;
    }
}

