/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies;

import com.intellij.util.graph.Graph;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ShortestPathUtil<Node> {
    private final HashSet<Node> myVisited = new HashSet();
    private final Set<ProcessingNode> myProcessingNodes = new HashSet<ProcessingNode>();
    private DefaultTreeModel myShortestPathTree;
    private final Graph<Node> myGraph;

    public ShortestPathUtil(Graph<Node> graph) {
        this.myGraph = graph;
    }

    public List<Node> getShortestPath(Node from, Node to) {
        boolean flag;
        ArrayList result = new ArrayList();
        if (this.myShortestPathTree == null || ((DefaultMutableTreeNode)this.myShortestPathTree.getRoot()).getUserObject() != from) {
            this.shortestPath(from);
        }
        return (flag = this.traverse(to, result)) ? result : null;
    }

    private boolean traverse(Node to, List<Node> path) {
        DefaultMutableTreeNode treeNode = this.findNodeByUserObject(to);
        if (treeNode == null) {
            return false;
        }
        while (treeNode != null) {
            path.add(treeNode.getUserObject());
            treeNode = (DefaultMutableTreeNode)treeNode.getParent();
        }
        return true;
    }

    private TreeModel shortestPath(Node from) {
        this.myShortestPathTree = new DefaultTreeModel(new DefaultMutableTreeNode(from));
        this.myProcessingNodes.add(new ProcessingNode(null, from, 0));
        while (!this.myProcessingNodes.isEmpty()) {
            this.moveToVisited();
        }
        this.myVisited.clear();
        this.myProcessingNodes.clear();
        return this.myShortestPathTree;
    }

    private DefaultMutableTreeNode findNodeByUserObject(final Node nodeToFind) {
        final ArrayList parent = new ArrayList();
        TreeUtil.traverseDepth((TreeNode)((TreeNode)this.myShortestPathTree.getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                if (treeNode.getUserObject() != null && treeNode.getUserObject().equals(nodeToFind)) {
                    parent.add(treeNode);
                    return false;
                }
                return true;
            }
        });
        return parent.size() > 0 ? (DefaultMutableTreeNode)parent.get(0) : null;
    }

    private void moveToVisited() {
        DefaultMutableTreeNode parentNode;
        ProcessingNode priorityNode = null;
        for (ProcessingNode processingNode : this.myProcessingNodes) {
            if (priorityNode != null) {
                if (priorityNode.getPriority() <= processingNode.getPriority()) continue;
                priorityNode = processingNode;
                continue;
            }
            priorityNode = processingNode;
        }
        this.myProcessingNodes.remove(priorityNode);
        this.myVisited.add(priorityNode.myToNode);
        if (priorityNode.myFromNode != null && (parentNode = this.findNodeByUserObject(priorityNode.myFromNode)) != null) {
            this.myShortestPathTree.insertNodeInto(new DefaultMutableTreeNode(priorityNode.myToNode), parentNode, 0);
        }
        this.moveAdjacentVerticesToProcessing(priorityNode);
    }

    private void moveAdjacentVerticesToProcessing(ProcessingNode priorityNode) {
        Object fromNode = priorityNode.getToNode();
        int priority = priorityNode.getPriority();
        Iterator iterator = this.myGraph.getIn(fromNode);
        while (iterator.hasNext()) {
            Object toNode = iterator.next();
            if (this.myVisited.contains(toNode)) continue;
            ProcessingNode processingNode = this.getProcessingNodeByFromNode(toNode);
            if (processingNode == null) {
                this.myProcessingNodes.add(new ProcessingNode(fromNode, toNode, priority + 1));
                continue;
            }
            if (processingNode.getPriority() <= priority + 1) continue;
            processingNode.setPriority(priority + 1);
            processingNode.setFromNode(fromNode);
        }
    }

    private ProcessingNode getProcessingNodeByFromNode(Node fromNode) {
        for (ProcessingNode processingNode : this.myProcessingNodes) {
            if (processingNode.getFromNode() != fromNode) continue;
            return processingNode;
        }
        return null;
    }

    private class ProcessingNode {
        private Node myFromNode;
        private Node myToNode;
        private int myPriority;

        public ProcessingNode(Node fromNode, Node toNode, int priority) {
            this.myFromNode = fromNode;
            this.myToNode = toNode;
            this.myPriority = priority;
        }

        public Node getFromNode() {
            return this.myFromNode;
        }

        public Node getToNode() {
            return this.myToNode;
        }

        public int getPriority() {
            return this.myPriority;
        }

        public void setPriority(int priority) {
            this.myPriority = priority;
        }

        public void setFromNode(Node fromNode) {
            this.myFromNode = fromNode;
        }

        public void setToNode(Node toNode) {
            this.myToNode = toNode;
        }
    }
}

