/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public class ProjectConversionUtil {
    @NonNls
    private static final String PROJECT_FILES_BACKUP = "projectFilesBackup";
    @NonNls
    private static final String BACKUP_EXTENSION = "backup";

    private ProjectConversionUtil() {
    }

    public static File backupFile(File file) throws IOException {
        String fileName = FileUtil.createSequentFileName((File)file.getParentFile(), (String)file.getName(), (String)BACKUP_EXTENSION);
        File backup = new File(file.getParentFile(), fileName);
        FileUtil.copy((File)file, (File)backup);
        return backup;
    }

    public static File backupFiles(Collection<File> files, File parentDir) throws IOException {
        File backupDir = ProjectConversionUtil.getBackupDir(parentDir);
        ProjectConversionUtil.backupFiles(files, parentDir, backupDir);
        return backupDir;
    }

    public static void backupFiles(Collection<File> files, File parentDir, File backupDir) throws IOException {
        backupDir.mkdirs();
        for (File file : files) {
            File target;
            if (FileUtil.isAncestor((File)parentDir, (File)file, (boolean)true)) {
                String relativePath = FileUtil.getRelativePath((File)parentDir, (File)file);
                target = new File(backupDir.getAbsolutePath() + File.separator + relativePath);
                FileUtil.createParentDirs((File)target);
            } else {
                target = new File(backupDir, file.getName());
            }
            FileUtil.copy((File)file, (File)target);
        }
    }

    public static File getBackupDir(File parentDir) {
        String dirName = FileUtil.createSequentFileName((File)parentDir, (String)PROJECT_FILES_BACKUP, (String)"");
        return new File(parentDir, dirName);
    }
}

