/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.options.ProcessedModulesTable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TableUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class AnnotationProcessorsConfigurable
implements SearchableConfigurable {
    private ProcessedModulesTable myModulesTable;
    private final Project myProject;
    private JRadioButton myRbClasspath;
    private JRadioButton myRbProcessorsPath;
    private TextFieldWithBrowseButton myProcessorPathField;
    private ProcessorTableModel myProcessorsModel;
    private JCheckBox myCbEnableProcessing;
    private JButton myRemoveButton;
    private Table myProcessorTable;
    private JButton myAddButton;

    public AnnotationProcessorsConfigurable(Project project) {
        this.myProject = project;
    }

    public String getDisplayName() {
        return "Annotation Processors";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.annotationProcessors";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.myCbEnableProcessing = new JCheckBox("Enable annotation processing");
        this.myRbClasspath = new JRadioButton("Obtain processors from project classpath");
        this.myRbProcessorsPath = new JRadioButton("Processor path:");
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbClasspath);
        group.add(this.myRbProcessorsPath);
        this.myProcessorPathField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile[] files = FileChooser.chooseFiles((Component)AnnotationProcessorsConfigurable.this.myProcessorPathField, (FileChooserDescriptor)new FileChooserDescriptor(true, true, true, true, false, true));
                if (files.length > 0) {
                    StringBuilder builder = new StringBuilder();
                    for (VirtualFile file : files) {
                        if (builder.length() > 0) {
                            builder.append(File.pathSeparator);
                        }
                        builder.append(FileUtil.toSystemDependentName((String)file.getPath()));
                    }
                    AnnotationProcessorsConfigurable.this.myProcessorPathField.setText(builder.toString());
                }
            }
        });
        JPanel processorTablePanel = new JPanel(new BorderLayout());
        this.myProcessorsModel = new ProcessorTableModel();
        processorTablePanel.setBorder(new TitledBorder("Annotation Processors"));
        this.myProcessorTable = new Table((TableModel)this.myProcessorsModel);
        processorTablePanel.add((Component)new JScrollPane((Component)this.myProcessorTable), "Center");
        JPanel buttons = new JPanel(new GridBagLayout());
        this.myAddButton = new JButton("Add");
        buttons.add((Component)this.myAddButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.myRemoveButton = new JButton("Remove");
        buttons.add((Component)this.myRemoveButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
        processorTablePanel.add((Component)buttons, "East");
        processorTablePanel.setPreferredSize(new Dimension(processorTablePanel.getPreferredSize().width, 50));
        this.myModulesTable = new ProcessedModulesTable(this.myProject);
        this.myModulesTable.setBorder(BorderFactory.createTitledBorder("Processed Modules"));
        MultiLineLabel noteMessage = new MultiLineLabel("Source files generated by annotation processors will be stored under the project output directory.\nTo override this behaviour for certain modules you may specify the directory name in the table below.\nIf specified, the directory will be created under corresponding module's content root.");
        MultiLineLabel warning = new MultiLineLabel("WARNING!\nAll source files located in the generated sources output directory WILL BE EXCLUDED from annotation processing.\nIf option 'Clear output directory on rebuild' is enabled,\nthe entire contents of directories specified in the table below WILL BE CLEARED on rebuild.");
        warning.setFont(warning.getFont().deriveFont(1));
        mainPanel.add((Component)this.myCbEnableProcessing, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.myRbClasspath, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.myRbProcessorsPath, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.myProcessorPathField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        mainPanel.add((Component)processorTablePanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        mainPanel.add((Component)noteMessage, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        mainPanel.add((Component)warning, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        mainPanel.add((Component)this.myModulesTable, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.myRbClasspath.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AnnotationProcessorsConfigurable.this.updateEnabledState();
            }
        });
        this.myProcessorTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AnnotationProcessorsConfigurable.this.updateEnabledState();
                }
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor cellEditor = AnnotationProcessorsConfigurable.this.myProcessorTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                ProcessorTableModel model = (ProcessorTableModel)AnnotationProcessorsConfigurable.this.myProcessorTable.getModel();
                int inserdedIndex = model.addRow();
                TableUtil.editCellAt((JTable)AnnotationProcessorsConfigurable.this.myProcessorTable, (int)inserdedIndex, (int)0);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.removeSelectedItems((JTable)AnnotationProcessorsConfigurable.this.myProcessorTable);
            }
        });
        this.myCbEnableProcessing.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AnnotationProcessorsConfigurable.this.updateEnabledState();
            }
        });
        this.updateEnabledState();
        return mainPanel;
    }

    private void updateEnabledState() {
        boolean enabled = this.myCbEnableProcessing.isSelected();
        boolean useProcessorpath = !this.myRbClasspath.isSelected();
        this.myRbClasspath.setEnabled(enabled);
        this.myRbProcessorsPath.setEnabled(enabled);
        this.myProcessorPathField.setEnabled(enabled && useProcessorpath);
        this.myRemoveButton.setEnabled(enabled && this.myProcessorTable.getSelectedRow() >= 0);
        this.myAddButton.setEnabled(enabled);
        this.myProcessorTable.setEnabled(enabled);
        JTableHeader header = this.myProcessorTable.getTableHeader();
        if (header != null) {
            header.repaint();
        }
        this.myModulesTable.setEnabled(enabled);
    }

    public boolean isModified() {
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        if (config.isAnnotationProcessorsEnabled() != this.myCbEnableProcessing.isSelected()) {
            return true;
        }
        if (config.isObtainProcessorsFromClasspath() != this.myRbClasspath.isSelected()) {
            return true;
        }
        if (!FileUtil.pathsEqual((String)config.getProcessorPath(), (String)FileUtil.toSystemIndependentName((String)this.myProcessorPathField.getText().trim()))) {
            return true;
        }
        Map<String, String> map = this.myProcessorsModel.exportToMap();
        if (!((Object)map).equals(config.getAnnotationProcessorsMap())) {
            return true;
        }
        return !((Object)this.getMarkedModules()).equals(config.getAnotationProcessedModules());
    }

    public void apply() throws ConfigurationException {
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        config.setAnnotationProcessorsEnabled(this.myCbEnableProcessing.isSelected());
        config.setObtainProcessorsFromClasspath(this.myRbClasspath.isSelected());
        config.setProcessorsPath(FileUtil.toSystemIndependentName((String)this.myProcessorPathField.getText().trim()));
        config.setAnnotationProcessorsMap(this.myProcessorsModel.exportToMap());
        config.setAnotationProcessedModules(this.getMarkedModules());
    }

    private Map<Module, String> getMarkedModules() {
        HashMap result = new HashMap();
        for (Pair<Module, String> pair : this.myModulesTable.getAllModules()) {
            result.put(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    public void reset() {
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        this.myCbEnableProcessing.setSelected(config.isAnnotationProcessorsEnabled());
        boolean obtainFromClasspath = config.isObtainProcessorsFromClasspath();
        if (obtainFromClasspath) {
            this.myRbClasspath.setSelected(true);
        } else {
            this.myRbProcessorsPath.setSelected(true);
        }
        this.myProcessorPathField.setText(FileUtil.toSystemDependentName((String)config.getProcessorPath()));
        this.myProcessorsModel.setProcessorMap(config.getAnnotationProcessorsMap());
        this.myModulesTable.removeAllElements();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!config.isAnnotationProcessingEnabled(module)) continue;
            this.myModulesTable.addModule(module, config.getGeneratedSourceDirName(module));
        }
        this.myModulesTable.sort(new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    public void disposeUIResources() {
    }

    private static final class ProcessorTableRow {
        public static final int NAME_COLUMN = 0;
        public static final int OPTIONS_COLUMN = 1;
        public String name = "";
        public String options = "";

        public ProcessorTableRow() {
        }

        public ProcessorTableRow(String name, String options) {
            this.name = name != null ? name : "";
            this.options = options != null ? options : "";
        }
    }

    private static class ProcessorTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<ProcessorTableRow> myRows = new ArrayList<ProcessorTableRow>();

        private ProcessorTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Processor FQ Name";
                }
                case 1: {
                    return "Processor Run Options (space-separated \"key=value\" pairs)";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.myRows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ProcessorTableRow row = this.myRows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.name;
                }
                case 1: {
                    return row.options;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                ProcessorTableRow row = this.myRows.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        row.name = (String)aValue;
                        break;
                    }
                    case 1: {
                        row.options = (String)aValue;
                    }
                }
            }
        }

        public void removeRow(int idx) {
            this.myRows.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public int addRow() {
            this.myRows.add(new ProcessorTableRow());
            int inserted = this.myRows.size() - 1;
            this.fireTableRowsInserted(inserted, inserted);
            return inserted;
        }

        public void setProcessorMap(Map<String, String> processorMap) {
            this.clear();
            if (processorMap.size() > 0) {
                for (Map.Entry<String, String> entry : processorMap.entrySet()) {
                    this.myRows.add(new ProcessorTableRow(entry.getKey(), entry.getValue()));
                }
                Collections.sort(this.myRows, new Comparator<ProcessorTableRow>(){

                    @Override
                    public int compare(ProcessorTableRow o1, ProcessorTableRow o2) {
                        return o1.name.compareToIgnoreCase(o2.name);
                    }
                });
                this.fireTableRowsInserted(0, processorMap.size() - 1);
            }
        }

        public void clear() {
            int count = this.myRows.size();
            if (count > 0) {
                this.myRows.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        public Map<String, String> exportToMap() {
            HashMap map = new HashMap();
            for (ProcessorTableRow row : this.myRows) {
                String name;
                if (row.name == null || (name = row.name.trim()).length() <= 0 || map.containsKey(name)) continue;
                map.put(name, row.options);
            }
            return map;
        }
    }
}

