/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.classParsing.SignatureParser;
import com.intellij.compiler.classParsing.SignatureParsingException;
import com.intellij.util.ArrayUtil;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

public class BoundsParser
extends SignatureParser {
    final List<String> myInterfaceBounds = new ArrayList<String>();
    private int myParsingBound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseClassBound(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        ++this.myParsingBound;
        try {
            super.parseClassBound(it, buf);
        }
        finally {
            --this.myParsingBound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseInterfaceBound(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        ++this.myParsingBound;
        try {
            super.parseInterfaceBound(it, buf);
        }
        finally {
            --this.myParsingBound;
        }
    }

    @Override
    public void parseClassTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (this.myParsingBound > 0) {
            int start = buf.length();
            super.parseClassTypeSignature(it, buf);
            String qName = BoundsParser.convertToQalifiedName(buf.substring(start + 1, buf.length() - 1));
            this.myInterfaceBounds.add(qName);
        } else {
            super.parseClassTypeSignature(it, buf);
        }
    }

    private static String convertToQalifiedName(String ifaceSignature) {
        ifaceSignature = ifaceSignature.replaceAll("<.*>", "");
        return ifaceSignature.replace('/', '.');
    }

    public String[] getBounds() {
        return ArrayUtil.toStringArray(this.myInterfaceBounds);
    }

    public static String[] getBounds(String classSignature) throws SignatureParsingException {
        BoundsParser parser = new BoundsParser();
        parser.parseClassSignature(new StringCharacterIterator(classSignature), new StringBuilder());
        return parser.getBounds();
    }
}

