/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class EclipseCompilerOutputParser
extends OutputParser {
    private final String myOutputDir;
    @NonNls
    private static final Pattern PATH_PATTERN = Pattern.compile("\\s*(.*) - #.*");
    @NonNls
    private static final Pattern COMPILED_PATTERN = Pattern.compile("\\[\\d* unit(s)? compiled\\]");
    @NonNls
    private static final Pattern GENERATED_PATTERN = Pattern.compile("\\[\\d* \\.class file(s)? generated\\]");

    public EclipseCompilerOutputParser(String outputDir) {
        this.myOutputDir = outputDir;
    }

    @Override
    public boolean processMessageLine(OutputParser.Callback callback) {
        String line = callback.getNextLine();
        if (line == null) {
            return false;
        }
        if (line.trim().length() == 0) {
            return true;
        }
        if (line.startsWith("[parsing ")) {
            Matcher matcher = PATH_PATTERN.matcher(line.substring("[parsing ".length()));
            matcher.matches();
            String path = matcher.group(1);
            callback.setProgressText(CompilerBundle.message((String)"eclipse.compiler.parsing", (Object[])new Object[]{path}));
            callback.fileProcessed(path);
            return true;
        }
        if (line.startsWith("[reading ")) {
            callback.setProgressText(CompilerBundle.message((String)"eclipse.compiler.reading", (Object[])new Object[0]));
            return true;
        }
        if (line.startsWith("[analyzing ")) {
            Matcher matcher = PATH_PATTERN.matcher(line.substring("[analyzing ".length()));
            matcher.matches();
            String path = matcher.group(1);
            callback.setProgressText(CompilerBundle.message((String)"eclipse.compiler.analyzing", (Object[])new Object[]{path}));
            return true;
        }
        if (line.startsWith("[completed ")) {
            return true;
        }
        if (line.startsWith("[writing ")) {
            Matcher matcher = PATH_PATTERN.matcher(line.substring("[writing ".length()));
            matcher.matches();
            String path = matcher.group(1);
            String absPath = FileUtil.toSystemDependentName((String)(this.myOutputDir + '/' + path));
            callback.fileGenerated(new FileObject(new File(absPath)));
            return true;
        }
        if (COMPILED_PATTERN.matcher(line).matches() || GENERATED_PATTERN.matcher(line).matches()) {
            return true;
        }
        callback.message(CompilerMessageCategory.INFORMATION, line, null, -1, -1);
        return true;
    }
}

