/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.StringInterner;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InternedPath {
    @NotNull
    private final List<String> myValue;

    public InternedPath(StringInterner interner, String url, char separator) {
        this.myValue = InternedPath.convert(interner, url, separator);
    }

    public String toString() {
        return InternedPath.join(this.myValue, '/');
    }

    public static List<String> convert(StringInterner interner, String value, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int len = value.length();
        for (int idx = 0; idx < len; ++idx) {
            if (value.charAt(idx) != delim) continue;
            result.add(interner.intern(value.substring(start, idx)));
            start = idx + 1;
        }
        if (start < value.length()) {
            result.add(interner.intern(value.substring(start)));
        }
        if (len > 0 && value.charAt(len - 1) == delim) {
            result.add("");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(List<String> value, char separator) {
        int size = value.size();
        if (size > 1) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                builder.append(value.get(0));
                for (int idx = 1; idx < size; ++idx) {
                    builder.append(separator).append(value.get(idx));
                }
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        if (size == 1) {
            return value.get(0);
        }
        return "";
    }
}

