/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class FileIndexCompileScope
extends UserDataHolderBase
implements CompileScope {
    protected abstract FileIndex[] getFileIndices();

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        FileIndex[] fileIndices;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (FileIndex fileIndex : fileIndices = this.getFileIndices()) {
            fileIndex.iterateContent((ContentIterator)new CompilerContentIterator(fileType, fileIndex, inSourceOnly, files));
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/FileIndexCompileScope.getFiles must not return null");
        }
        return virtualFileArray;
    }
}

