/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SymbolTable {
    private final PersistentStringEnumerator myTrie;
    private static final int STRING_CACHE_SIZE = 1024;
    private final SLRUCache<Integer, String> myIndexStringCache = new SLRUCache<Integer, String>(2048, 1024){

        @NotNull
        public String createValue(Integer key) {
            String string;
            try {
                string = (String)SymbolTable.this.myTrie.valueOf(key.intValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/compiler/SymbolTable$1.createValue must not return null");
            }
            return string;
        }
    };
    private final SLRUCache<String, Integer> myStringIndexCache = new SLRUCache<String, Integer>(2048, 1024){

        @NotNull
        public Integer createValue(String key) {
            Integer n;
            try {
                n = SymbolTable.this.myTrie.enumerate((Object)key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (n == null) {
                throw new IllegalStateException("@NotNull method com/intellij/compiler/SymbolTable$2.createValue must not return null");
            }
            return n;
        }
    };

    public SymbolTable(File file) throws CacheCorruptedException {
        try {
            if (!file.exists()) {
                FileUtil.createIfDoesntExist((File)file);
            }
            this.myTrie = new PersistentStringEnumerator(file);
        }
        catch (PersistentEnumerator.CorruptedException e) {
            throw new CacheCorruptedException(CompilerBundle.message((String)"error.compiler.caches.corrupted", (Object[])new Object[0]), e);
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public synchronized int getId(@NotNull String symbol) throws CacheCorruptedException {
        if (symbol == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/SymbolTable.getId must not be null");
        }
        if (symbol.length() == 0) {
            return -1;
        }
        try {
            return (Integer)this.myStringIndexCache.get((Object)symbol);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw new CacheCorruptedException(e.getCause());
            }
            throw e;
        }
    }

    public synchronized String getSymbol(int id) throws CacheCorruptedException {
        if (id == -1) {
            return "";
        }
        try {
            return (String)this.myIndexStringCache.get((Object)id);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw new CacheCorruptedException(e.getCause());
            }
            throw e;
        }
    }

    public synchronized void dispose() throws CacheCorruptedException {
        try {
            this.myIndexStringCache.clear();
            this.myStringIndexCache.clear();
            this.myTrie.close();
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }
}

