/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AdjustPackageNameFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix");
    private final PsiJavaFile myFile;
    private final PsiPackageStatement myStatement;
    private final PsiPackage myTargetPackage;

    public AdjustPackageNameFix(PsiJavaFile file, PsiPackageStatement statement, PsiPackage targetPackage) {
        this.myFile = file;
        this.myStatement = statement;
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("adjust.package.text", this.myTargetPackage.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.package.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable() {
        return this.myFile != null && this.myFile.isValid() && this.myFile.getManager().isInProject((PsiElement)this.myFile) && this.myTargetPackage != null && this.myTargetPackage.isValid() && (this.myStatement == null || this.myStatement.isValid());
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix.applyFix must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite((PsiFile)this.myFile)) {
            return;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myFile.getProject()).getElementFactory();
            if (this.myTargetPackage.getQualifiedName().length() == 0) {
                if (this.myStatement != null) {
                    this.myStatement.delete();
                }
            } else {
                PsiPackageStatement packageStatement = factory.createPackageStatement(this.myTargetPackage.getQualifiedName());
                if (this.myStatement != null) {
                    this.myStatement.getPackageReference().replace((PsiElement)packageStatement.getPackageReference());
                } else {
                    this.myFile.addAfter((PsiElement)packageStatement, null);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

