/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.vcs.FileStatus;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends InspectionTreeNode {
    private boolean myHasDescriptorsUnder;
    private CommonProblemDescriptor mySingleDescriptor;
    protected InspectionTool myTool;

    public RefElementNode(Object userObject, InspectionTool tool) {
        super(userObject);
        this.myHasDescriptorsUnder = false;
        this.mySingleDescriptor = null;
        this.myTool = tool;
    }

    public RefElementNode(@NotNull RefElement element, InspectionTool inspectionTool) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ui/RefElementNode.<init> must not be null");
        }
        super(element);
        this.myHasDescriptorsUnder = false;
        this.mySingleDescriptor = null;
        this.myTool = inspectionTool;
    }

    public boolean hasDescriptorsUnder() {
        return this.myHasDescriptorsUnder;
    }

    @Nullable
    public RefEntity getElement() {
        return (RefEntity)this.getUserObject();
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        RefEntity refEntity = this.getElement();
        if (refEntity == null) {
            return null;
        }
        return refEntity.getIcon(expanded);
    }

    @Override
    public int getProblemCount() {
        return Math.max(1, super.getProblemCount());
    }

    @Override
    public String toString() {
        RefEntity element = this.getElement();
        if (element == null || !element.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getQualifiedName();
    }

    @Override
    public boolean isValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isResolved() {
        return this.myTool.isElementIgnored(this.getElement());
    }

    @Override
    public void ignoreElement() {
        this.myTool.ignoreCurrentElement(this.getElement());
        super.ignoreElement();
    }

    @Override
    public void amnesty() {
        this.myTool.amnesty(this.getElement());
        super.amnesty();
    }

    @Override
    public FileStatus getNodeStatus() {
        return this.myTool.getElementStatus(this.getElement());
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        if (newChild instanceof ProblemDescriptionNode) {
            this.myHasDescriptorsUnder = true;
        }
    }

    public void setProblem(CommonProblemDescriptor descriptor) {
        this.mySingleDescriptor = descriptor;
    }

    public CommonProblemDescriptor getProblem() {
        return this.mySingleDescriptor;
    }
}

