/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SillyAssignmentInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = JavaErrorMessages.message("assignment.to.itself", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SillyAssignment" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection.getShortName must not return null");
        }
        return "SillyAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                SillyAssignmentInspection.checkSillyAssignment(expression, holder);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitVariable(PsiVariable variable) {
                PsiReferenceExpression refExpr;
                PsiExpression lExpr;
                PsiExpression initializer = variable.getInitializer();
                if (initializer instanceof PsiAssignmentExpression && (lExpr = ((PsiAssignmentExpression)initializer).getLExpression()) instanceof PsiReferenceExpression && !(refExpr = (PsiReferenceExpression)lExpr).isQualified() && refExpr.isReferenceTo((PsiElement)variable)) {
                    holder.registerProblem((PsiElement)lExpr, JavaErrorMessages.message("assignment.to.declared.variable", variable.getName()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, (LocalQuickFix[])null);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private static void checkSillyAssignment(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        PsiReferenceExpression rRef;
        if (assignment.getOperationSign().getTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression lExpression = assignment.getLExpression();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        lExpression = PsiUtil.deparenthesizeExpression((PsiExpression)lExpression);
        rExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rExpression);
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return;
        }
        if (!(rExpression instanceof PsiReferenceExpression)) {
            if (!(rExpression instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rExpression;
            PsiExpression assignee = rAssignmentExpression.getLExpression();
            if (!(assignee instanceof PsiReferenceExpression)) {
                return;
            }
            rRef = (PsiReferenceExpression)assignee;
        } else {
            rRef = (PsiReferenceExpression)rExpression;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
        PsiManager manager = assignment.getManager();
        if (!SillyAssignmentInspection.sameInstanceReferences(lRef, rRef, manager)) {
            return;
        }
        holder.registerProblem((PsiElement)assignment, JavaErrorMessages.message("assignment.to.itself", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, (LocalQuickFix[])null);
    }

    private static boolean sameInstanceReferences(PsiReferenceExpression lRef, PsiReferenceExpression rRef, PsiManager manager) {
        PsiElement rResolved;
        PsiElement lResolved = lRef.resolve();
        if (!manager.areElementsEquivalent(lResolved, rResolved = rRef.resolve())) {
            return false;
        }
        PsiExpression lQualifier = lRef.getQualifierExpression();
        PsiExpression rQualifier = rRef.getQualifierExpression();
        if (lQualifier instanceof PsiReferenceExpression && rQualifier instanceof PsiReferenceExpression) {
            return SillyAssignmentInspection.sameInstanceReferences((PsiReferenceExpression)lQualifier, (PsiReferenceExpression)rQualifier, manager);
        }
        if (Comparing.equal((Object)lQualifier, (Object)rQualifier)) {
            return true;
        }
        boolean lThis = lQualifier == null || lQualifier instanceof PsiThisExpression;
        boolean rThis = rQualifier == null || rQualifier instanceof PsiThisExpression;
        return lThis && rThis;
    }
}

