/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorImpl
extends CommonProblemDescriptorImpl
implements ProblemDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.ProblemDescriptorImpl");
    @NotNull
    private final SmartPsiElementPointer myStartSmartPointer;
    @Nullable
    private final SmartPsiElementPointer myEndSmartPointer;
    private final ProblemHighlightType myHighlightType;
    private Navigatable myNavigatable;
    private final boolean myAfterEndOfLine;
    private final TextRange myTextRangeInElement;
    private final boolean myShowTooltip;
    private final HintAction myHintAction;
    private TextAttributesKey myEnforcedTextAttributes;

    public ProblemDescriptorImpl(@NotNull PsiElement startElement, @NotNull PsiElement endElement, String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType, boolean isAfterEndOfLine, TextRange rangeInElement, boolean onTheFly) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        this(startElement, endElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, rangeInElement, null, onTheFly);
    }

    public ProblemDescriptorImpl(@NotNull PsiElement startElement, @NotNull PsiElement endElement, String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType, boolean isAfterEndOfLine, TextRange rangeInElement, @Nullable HintAction hintAction, boolean onTheFly) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        this(startElement, endElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, rangeInElement, true, hintAction, onTheFly);
    }

    public ProblemDescriptorImpl(@NotNull PsiElement startElement, @NotNull PsiElement endElement, String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType, boolean isAfterEndOfLine, TextRange rangeInElement, boolean tooltip, @Nullable HintAction hintAction, boolean onTheFly) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ProblemDescriptorImpl.<init> must not be null");
        }
        super((QuickFix[])fixes, descriptionTemplate);
        this.myShowTooltip = tooltip;
        this.myHintAction = hintAction;
        LOG.assertTrue(startElement.isValid(), (Object)startElement);
        LOG.assertTrue(startElement == endElement || endElement.isValid(), (Object)endElement);
        this.assertPhysical(startElement);
        if (startElement != endElement) {
            this.assertPhysical(endElement);
        }
        if (!(startElement.getTextRange().getStartOffset() < endElement.getTextRange().getEndOffset() || startElement instanceof PsiFile && endElement instanceof PsiFile)) {
            LOG.error("Empty PSI elements should not be passed to createDescriptor. Start: " + startElement + ", end: " + endElement);
        }
        this.myHighlightType = highlightType;
        Project project = startElement.getProject();
        boolean useLazy = !onTheFly || ApplicationManager.getApplication().isHeadlessEnvironment();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer smartPsiElementPointer = this.myStartSmartPointer = useLazy ? manager.createLazyPointer(startElement) : manager.createSmartPsiElementPointer(startElement);
        this.myEndSmartPointer = startElement == endElement ? null : (useLazy ? manager.createLazyPointer(endElement) : manager.createSmartPsiElementPointer(endElement));
        this.myAfterEndOfLine = isAfterEndOfLine;
        this.myTextRangeInElement = rangeInElement;
    }

    protected void assertPhysical(PsiElement element) {
        if (!element.isPhysical()) {
            LOG.error("Non-physical PsiElement. Physical element is required to be able to anchor the problem in the source tree: " + element + "; file: " + element.getContainingFile());
        }
    }

    public PsiElement getPsiElement() {
        PsiElement startElement = this.getStartElement();
        if (this.myEndSmartPointer == null) {
            return startElement;
        }
        PsiElement endElement = this.getEndElement();
        if (startElement == endElement) {
            return startElement;
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartSmartPointer.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndSmartPointer == null ? this.getStartElement() : this.myEndSmartPointer.getElement();
    }

    public int getLineNumber() {
        Document document;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return -1;
        }
        if (!psiElement.isValid()) {
            return -1;
        }
        LOG.assertTrue(psiElement.isPhysical());
        PsiFile containingFile = psiElement.getContainingFile();
        PsiElement containingFileContext = containingFile.getContext();
        if (containingFileContext != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((document = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(containingFile)) == null) {
            return -1;
        }
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            return -1;
        }
        if (containingFileContext != null) {
            textRange = textRange.shiftRight(PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)psiElement));
        }
        return document.getLineNumber(textRange.getStartOffset()) + 1;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setTextAttributes(TextAttributesKey key) {
        this.myEnforcedTextAttributes = key;
    }

    public TextAttributesKey getEnforcedTextAttributes() {
        return this.myEnforcedTextAttributes;
    }

    public TextRange getTextRangeForNavigation() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            return null;
        }
        return textRange.shiftRight(PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)this.getPsiElement()));
    }

    public TextRange getTextRange() {
        PsiElement endElement;
        PsiElement startElement = this.getStartElement();
        PsiElement psiElement = endElement = this.myEndSmartPointer == null ? startElement : this.getEndElement();
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange textRange = startElement.getTextRange();
        if (startElement == endElement) {
            if (this.isAfterEndOfLine()) {
                return new TextRange(textRange.getEndOffset(), textRange.getEndOffset());
            }
            if (this.myTextRangeInElement != null) {
                return new TextRange(textRange.getStartOffset() + this.myTextRangeInElement.getStartOffset(), textRange.getStartOffset() + this.myTextRangeInElement.getEndOffset());
            }
            return textRange;
        }
        return new TextRange(textRange.getStartOffset(), endElement.getTextRange().getEndOffset());
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    public void setNavigatable(Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    public HintAction getHintAction() {
        return this.myHintAction;
    }

    public boolean showTooltip() {
        return this.myShowTooltip;
    }
}

