/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import java.net.MalformedURLException;
import java.net.URL;

public class DescriptorComposer
extends HTMLComposerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.DescriptorComposer");
    private final DescriptorProviderInspection myTool;

    public DescriptorComposer(DescriptorProviderInspection tool) {
        this.myTool = tool;
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refEntity) {
        this.genPageHeader(buf, refEntity);
        if (this.myTool.getDescriptions(refEntity) != null) {
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
            CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refEntity);
            LOG.assertTrue(descriptions != null);
            this.startList(buf);
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                this.startListItem(buf);
                this.composeDescription(description, i, buf, refEntity);
                DescriptorComposer.doneListItem(buf);
            }
            this.doneList(buf);
            this.appendResolution(buf, this.myTool, refEntity);
        } else {
            this.appendNoProblems(buf);
        }
    }

    protected void composeAdditionalDescription(StringBuffer buf, RefEntity refEntity) {
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refElement, CommonProblemDescriptor descriptor) {
        CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refElement);
        int problemIdx = 0;
        if (descriptions != null) {
            problemIdx = -1;
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                if (description != descriptor) continue;
                problemIdx = i;
                break;
            }
            if (problemIdx == -1) {
                return;
            }
        }
        this.genPageHeader(buf, refElement);
        DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
        buf.append("<br>");
        DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
        this.composeDescription(descriptor, problemIdx, buf, refElement);
        if (refElement instanceof RefElement && !((RefElement)refElement).isValid()) {
            return;
        }
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            buf.append("<br><br>");
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
            buf.append("<br>");
            DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            int idx = 0;
            for (QuickFix fix : fixes) {
                buf.append("<font style=\"font-family:verdana;\"");
                buf.append("<a HREF=\"file://bred.txt#invokelocal:" + idx++);
                buf.append("\">");
                buf.append(fix.getName());
                buf.append("</a></font>");
                buf.append("<br>");
                DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            }
        }
    }

    protected void composeDescription(CommonProblemDescriptor description, int i, StringBuffer buf, RefEntity refElement) {
        PsiElement expression = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement() : null;
        StringBuffer anchor = new StringBuffer();
        VirtualFile vFile = null;
        if (expression != null) {
            vFile = expression.getContainingFile().getVirtualFile();
            if (vFile instanceof VirtualFileWindow) {
                vFile = ((VirtualFileWindow)vFile).getDelegate();
            }
            anchor.append("<a HREF=\"");
            try {
                if (this.myExporter == null) {
                    anchor.append(new URL(vFile.getUrl() + "#descr:" + i));
                } else {
                    anchor.append(this.myExporter.getURL(refElement));
                }
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            anchor.append("\">");
            anchor.append(ProblemDescriptionNode.extractHighlightedText(description, expression).replaceAll("\\$", "\\\\\\$"));
            anchor.append("</a>");
        } else {
            anchor.append("<font style=\"font-family:verdana; font-weight:bold; color:#FF0000\";>");
            anchor.append(InspectionsBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor.append("</font>");
        }
        String descriptionTemplate = description.getDescriptionTemplate();
        String res = descriptionTemplate.replaceAll("#ref", anchor.toString());
        int lineNumber = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
        StringBuffer lineAnchor = new StringBuffer();
        if (expression != null && lineNumber > 0) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            lineAnchor.append(InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            if (this.myExporter == null) {
                lineAnchor.append("<a HREF=\"");
                try {
                    int offset = doc.getLineStartOffset(lineNumber - 1);
                    offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
                    lineAnchor.append(new URL(vFile.getUrl() + "#" + offset));
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                }
                lineAnchor.append("\">");
            }
            lineAnchor.append(Integer.toString(lineNumber));
            lineAnchor.append("</a>");
            res = res.replaceAll("#loc", lineAnchor.toString());
        }
        buf.append(res);
        buf.append("<br>").append("<br>");
        this.composeAdditionalDescription(buf, refElement);
    }
}

