/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferenceInstruction
extends Instruction {
    private final PsiExpression myExpression;
    @Nullable
    private final String mySyntheticFieldName;

    public FieldReferenceInstruction(@NotNull PsiExpression expression, @Nullable @NonNls String syntheticFieldName) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction.<init> must not be null");
        }
        this.myExpression = expression;
        this.mySyntheticFieldName = syntheticFieldName;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitFieldReference(this, runner, stateBefore);
    }

    @Override
    public String toString() {
        return "FIELD_REFERENCE: " + this.myExpression.getText();
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression = this.myExpression;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction.getExpression must not return null");
        }
        return psiExpression;
    }

    @Nullable
    public PsiExpression getElementToAssert() {
        if (this.mySyntheticFieldName != null) {
            return this.myExpression;
        }
        return this.myExpression instanceof PsiArrayAccessExpression ? ((PsiArrayAccessExpression)this.myExpression).getArrayExpression() : ((PsiReferenceExpression)this.myExpression).getQualifierExpression();
    }
}

