/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RunInspectionIntention
implements IntentionAction {
    private final String myShortName;
    private final String myDisplayName;

    public RunInspectionIntention(InspectionProfileEntry tool) {
        this.myShortName = tool.getShortName();
        this.myDisplayName = tool.getDisplayName();
    }

    public RunInspectionIntention(HighlightDisplayKey key) {
        this.myShortName = key.toString();
        this.myDisplayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key);
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/RunInspectionIntention.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/RunInspectionIntention.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/RunInspectionIntention.isAvailable must not be null");
        }
        InspectionProfileEntry inspectionTool = InspectionProjectProfileManager.getInstance(project).getInspectionProfile().getInspectionTool(this.myShortName, (PsiElement)file);
        return !(inspectionTool instanceof LocalInspectionToolWrapper) || !(((LocalInspectionToolWrapper)inspectionTool).getTool() instanceof UnfairLocalInspectionTool);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/RunInspectionIntention.invoke must not be null");
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManagerEx.getInstance((Project)project);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, new AnalysisScope(file), module != null ? module.getName() : null, true, AnalysisUIOptions.getInstance(project), (PsiElement)file);
        AnalysisScope scope = new AnalysisScope(file);
        dlg.show();
        if (!dlg.isOK()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        scope = dlg.getScope(uiOptions, scope, project, module);
        InspectionProfileEntry baseTool = InspectionProjectProfileManager.getInstance(project).getInspectionProfile().getInspectionTool(this.myShortName, (PsiElement)file);
        RunInspectionIntention.rerunInspection(baseTool, managerEx, scope, (PsiElement)file);
    }

    public static void rerunInspection(InspectionProfileEntry baseTool, InspectionManagerEx managerEx, AnalysisScope scope, PsiElement psiElement) {
        InspectionProfileEntry[] profileEntries;
        InspectionProfileImpl profile = new InspectionProfileImpl(baseTool.getDisplayName());
        InspectionProfileImpl model = (InspectionProfileImpl)profile.getModifiableModel();
        for (InspectionProfileEntry entry : profileEntries = model.getInspectionTools(null)) {
            model.disableTool(entry.getShortName());
        }
        model.enableTool(baseTool.getShortName());
        try {
            Element element = new Element("toCopy");
            baseTool.writeSettings(element);
            model.getInspectionTool(baseTool.getShortName(), psiElement).readSettings(element);
        }
        catch (Exception e) {
            // empty catch block
        }
        model.setEditable(baseTool.getDisplayName());
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext(false);
        inspectionContext.setExternalProfile(model);
        inspectionContext.doInspections(scope, managerEx);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

