/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends BaseJavaLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.INTERNATIONALIZATION_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/LossyEncodingInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/LossyEncodingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("LossyEncoding" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/LossyEncodingInspection.getShortName must not return null");
        }
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/LossyEncodingInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/LossyEncodingInspection.checkFile must not be null");
        }
        if (ArrayUtil.find((Object[])file.getPsiRoots(), (Object)file) != 0) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String text = file.getText();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file.getProject(), virtualFile, text);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        int errorCount = 0;
        int start = -1;
        SmartList descriptors = new SmartList();
        for (int i = 0; i <= text.length(); ++i) {
            char c;
            char c2 = c = i == text.length() ? (char)'\u0000' : text.charAt(i);
            if (i == text.length() || LossyEncodingInspection.isRepresentable(c, charset)) {
                if (start == -1) continue;
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, new TextRange(start, i), InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
                descriptors.add(descriptor);
                start = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start != -1) continue;
            start = i;
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static boolean isRepresentable(char c, Charset charset) {
        String str = Character.toString(c);
        ByteBuffer out = charset.encode(str);
        CharBuffer buffer = charset.decode(out);
        return str.equals(buffer.toString());
    }
}

