/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaPsiElementResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariableTypeMacroBase
implements Macro {
    @Nullable
    protected abstract PsiElement[] getVariables(Expression[] var1, ExpressionContext var2);

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableTypeMacroBase.calculateLookupItems must not be null");
        }
        PsiElement[] vars = this.getVariables(params, context);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        for (PsiElement element : vars) {
            JavaTemplateUtil.addElementLookupItem(set, element);
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableTypeMacroBase.calculateResult must not be null");
        }
        PsiElement[] vars = this.getVariables(params, context);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new JavaPsiElementResult(vars[0]);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableTypeMacroBase.calculateQuickResult must not be null");
        }
        return null;
    }

    public String getDefaultValue() {
        return "a";
    }
}

