/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.EditVariableDialog;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditTemplateDialog
extends DialogWrapper {
    private final List<TemplateGroup> myTemplateGroups;
    private final TemplateImpl myTemplate;
    private final JTextField myKeyField;
    private final JTextField myDescription;
    private final ComboBox myGroupCombo;
    private final Editor myTemplateEditor;
    private ArrayList<Variable> myVariables = new ArrayList();
    private JComboBox myExpandByCombo;
    private final String myDefaultShortcutItem;
    private JCheckBox myCbReformat;
    private final Map<TemplateContextType, JCheckBox> myCbContextMap = new HashMap<TemplateContextType, JCheckBox>();
    private final Map<TemplateOptionalProcessor, JCheckBox> myCbOptionalProcessorMap = new HashMap<TemplateOptionalProcessor, JCheckBox>();
    private JButton myEditVariablesButton;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
    private final Map<TemplateOptionalProcessor, Boolean> myOptions;
    private final Map<TemplateContextType, Boolean> myContext;

    public EditTemplateDialog(Component parent, String title, TemplateImpl template, List<TemplateGroup> groups, String defaultShortcut, Map<TemplateOptionalProcessor, Boolean> options, Map<TemplateContextType, Boolean> context) {
        super(parent, true);
        this.myOptions = options;
        this.myContext = context;
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.setTitle(title);
        this.myTemplate = template;
        this.myTemplateGroups = groups;
        this.myDefaultShortcutItem = CodeInsightBundle.message((String)"dialog.edit.template.shortcut.default", (Object[])new Object[]{defaultShortcut});
        this.myKeyField = new JTextField();
        this.myDescription = new JTextField();
        this.myGroupCombo = new ComboBox(-1);
        this.myTemplateEditor = TemplateEditorUtil.createEditor(false, this.myTemplate.getString());
        this.init();
        this.reset();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.dialogs.edittemplate");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.template.impl.EditTemplateDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeyField;
    }

    public void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.gridx = 0;
        JPanel panel1 = new JPanel();
        panel1.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"dialog.edit.template.template.text.title", (Object[])new Object[0])));
        panel1.setPreferredSize(new Dimension(500, 160));
        panel1.setMinimumSize(new Dimension(500, 160));
        panel1.setLayout(new BorderLayout());
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        ++gbConstraints.gridy;
        panel1.add((Component)this.myTemplateEditor.getComponent(), "Center");
        panel.add((Component)panel1, gbConstraints);
        gbConstraints.weighty = 0.0;
        ++gbConstraints.gridy;
        this.myEditVariablesButton = new JButton(CodeInsightBundle.message((String)"dialog.edit.template.button.edit.variables", (Object[])new Object[0]));
        this.myEditVariablesButton.setDefaultCapable(false);
        this.myEditVariablesButton.setMaximumSize(this.myEditVariablesButton.getPreferredSize());
        panel.add((Component)this.myEditVariablesButton, gbConstraints);
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        ++gbConstraints.gridy;
        panel.add((Component)this.createTemplateOptionsPanel(), gbConstraints);
        gbConstraints.gridx = 1;
        panel.add((Component)this.createContextPanel(), gbConstraints);
        this.myKeyField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                EditTemplateDialog.this.validateOKButton();
            }
        });
        this.myTemplateEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                EditTemplateDialog.this.validateOKButton();
                EditTemplateDialog.this.validateEditVariablesButton();
            }
        });
        this.myEditVariablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTemplateDialog.this.editVariables();
            }
        });
        return panel;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 1;
        JLabel keyPrompt = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.abbreviation", (Object[])new Object[0]));
        keyPrompt.setLabelFor(this.myKeyField);
        panel.add((Component)keyPrompt, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        panel.add((Component)this.myKeyField, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 2;
        JLabel groupPrompt = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.group", (Object[])new Object[0]));
        groupPrompt.setLabelFor((Component)this.myGroupCombo);
        panel.add((Component)groupPrompt, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 3;
        this.myGroupCombo.setEditable(true);
        panel.add((Component)this.myGroupCombo, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        JLabel descriptionPrompt = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.description", (Object[])new Object[0]));
        descriptionPrompt.setLabelFor(this.myDescription);
        panel.add((Component)descriptionPrompt, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 3;
        gbConstraints.weightx = 1.0;
        panel.add((Component)this.myDescription, gbConstraints);
        return panel;
    }

    private JPanel createTemplateOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"dialog.edit.template.options.title", (Object[])new Object[0])));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.expand.with", (Object[])new Object[0])), gbConstraints);
        gbConstraints.gridx = 1;
        this.myExpandByCombo = new JComboBox();
        this.myExpandByCombo.addItem(this.myDefaultShortcutItem);
        this.myExpandByCombo.addItem(SPACE);
        this.myExpandByCombo.addItem(TAB);
        this.myExpandByCombo.addItem(ENTER);
        panel.add((Component)this.myExpandByCombo, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel.add((Component)new JPanel(), gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.gridwidth = 3;
        this.myCbReformat = new JCheckBox(CodeInsightBundle.message((String)"dialog.edit.template.checkbox.reformat.according.to.style", (Object[])new Object[0]));
        panel.add((Component)this.myCbReformat, gbConstraints);
        for (TemplateOptionalProcessor processor : this.myOptions.keySet()) {
            ++gbConstraints.gridy;
            JCheckBox cb = new JCheckBox(processor.getOptionName());
            panel.add((Component)cb, gbConstraints);
            this.myCbOptionalProcessorMap.put(processor, cb);
        }
        gbConstraints.weighty = 1.0;
        ++gbConstraints.gridy;
        panel.add((Component)new JPanel(), gbConstraints);
        return panel;
    }

    private JPanel createContextPanel() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditTemplateDialog.this.myExpandByCombo.setEnabled(!EditTemplateDialog.this.isEnabledInStaticContextOnly());
            }
        };
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"dialog.edit.template.context.title", (Object[])new Object[0])));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        int row = 0;
        int col = 0;
        for (TemplateContextType contextType : this.myContext.keySet()) {
            gbConstraints.gridy = row;
            gbConstraints.gridx = col;
            JCheckBox cb = new JCheckBox(contextType.getPresentableName());
            cb.getModel().addChangeListener(listener);
            panel.add((Component)cb, gbConstraints);
            this.myCbContextMap.put(contextType, cb);
            if (row == (this.myContext.size() + 1) / 2 - 1) {
                row = 0;
                col = 1;
                continue;
            }
            ++row;
        }
        for (JCheckBox checkBox : this.myCbContextMap.values()) {
            this.addUpdateHighlighterAction(checkBox);
        }
        return panel;
    }

    private boolean isEnabledInStaticContextOnly() {
        for (TemplateContextType type : this.myCbContextMap.keySet()) {
            JCheckBox cb = this.myCbContextMap.get(type);
            if (!(!type.isExpandableFromEditor() ? !cb.isSelected() : cb.isSelected())) continue;
            return false;
        }
        return true;
    }

    private void addUpdateHighlighterAction(JCheckBox checkbox) {
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTemplateDialog.this.updateHighlighter();
            }
        });
    }

    private void updateHighlighter() {
        TemplateContext templateContext = new TemplateContext();
        this.updateTemplateContext();
        TemplateEditorUtil.setHighlighter(this.myTemplateEditor, templateContext);
        ((EditorEx)this.myTemplateEditor).repaint(0, this.myTemplateEditor.getDocument().getTextLength());
    }

    private void validateEditVariablesButton() {
        ArrayList variables = new ArrayList();
        EditTemplateDialog.parseVariables(this.myTemplateEditor.getDocument().getCharsSequence(), variables);
        boolean enable = false;
        for (Object variable1 : variables) {
            Variable variable = (Variable)variable1;
            if (TemplateImpl.INTERNAL_VARS_SET.contains(variable.getName())) continue;
            enable = true;
        }
        this.myEditVariablesButton.setEnabled(enable);
    }

    private void validateOKButton() {
        boolean isEnabled = true;
        if (this.myKeyField.getText().trim().length() == 0) {
            isEnabled = false;
        }
        if (this.myTemplateEditor.getDocument().getTextLength() == 0) {
            isEnabled = false;
        }
        this.setOKActionEnabled(isEnabled);
    }

    private void reset() {
        JCheckBox cb;
        this.myKeyField.setText(this.myTemplate.getKey());
        this.myDescription.setText(this.myTemplate.getDescription());
        if (this.myTemplate.getShortcutChar() == 'D') {
            this.myExpandByCombo.setSelectedItem(this.myDefaultShortcutItem);
        } else if (this.myTemplate.getShortcutChar() == '\t') {
            this.myExpandByCombo.setSelectedItem(TAB);
        } else if (this.myTemplate.getShortcutChar() == '\n') {
            this.myExpandByCombo.setSelectedItem(ENTER);
        } else {
            this.myExpandByCombo.setSelectedItem(SPACE);
        }
        CommandProcessor.getInstance().executeCommand(null, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Document document = EditTemplateDialog.this.myTemplateEditor.getDocument();
                        document.replaceString(0, document.getTextLength(), (CharSequence)EditTemplateDialog.this.myTemplate.getString());
                    }
                });
            }
        }, "", null);
        TreeSet<String> groups = new TreeSet<String>();
        SchemesManager<TemplateGroup, TemplateGroup> schemesManager = TemplateSettings.getInstance().getSchemesManager();
        for (TemplateGroup templateGroup : this.myTemplateGroups) {
            if (schemesManager.isShared((Scheme)templateGroup)) continue;
            groups.add(templateGroup.getName());
        }
        Iterator<TemplateGroup> i$ = groups.iterator();
        while (i$.hasNext()) {
            String string;
            String groupName = string = (String)((Object)i$.next());
            this.myGroupCombo.addItem((Object)groupName);
        }
        this.myGroupCombo.setSelectedItem((Object)this.myTemplate.getGroupName());
        this.myVariables.clear();
        for (int i = 0; i < this.myTemplate.getVariableCount(); ++i) {
            Variable variable = new Variable(this.myTemplate.getVariableNameAt(i), this.myTemplate.getExpressionStringAt(i), this.myTemplate.getDefaultValueStringAt(i), this.myTemplate.isAlwaysStopAt(i));
            this.myVariables.add(variable);
        }
        for (TemplateContextType templateContextType : this.myCbContextMap.keySet()) {
            cb = this.myCbContextMap.get(templateContextType);
            cb.setSelected(this.myContext.get(templateContextType));
        }
        this.myCbReformat.setSelected(this.myTemplate.isToReformat());
        for (TemplateOptionalProcessor templateOptionalProcessor : this.myCbOptionalProcessorMap.keySet()) {
            cb = this.myCbOptionalProcessorMap.get(templateOptionalProcessor);
            cb.setSelected(this.myOptions.get(templateOptionalProcessor));
        }
        this.myExpandByCombo.setEnabled(!this.isEnabledInStaticContextOnly());
        this.updateHighlighter();
        this.validateOKButton();
        this.validateEditVariablesButton();
    }

    public void apply() {
        this.updateVariablesByTemplateText();
        this.myTemplate.setKey(this.myKeyField.getText().trim());
        this.myTemplate.setDescription(this.myDescription.getText().trim());
        this.myTemplate.setGroupName(((String)this.myGroupCombo.getSelectedItem()).trim());
        Object selectedItem = this.myExpandByCombo.getSelectedItem();
        if (this.myDefaultShortcutItem.equals(selectedItem)) {
            this.myTemplate.setShortcutChar('D');
        } else if (TAB.equals(selectedItem)) {
            this.myTemplate.setShortcutChar('\t');
        } else if (ENTER.equals(selectedItem)) {
            this.myTemplate.setShortcutChar('\n');
        } else {
            this.myTemplate.setShortcutChar(' ');
        }
        this.myTemplate.removeAllParsed();
        Iterator<Object> i$ = this.myVariables.iterator();
        while (i$.hasNext()) {
            Variable myVariable;
            Variable variable = myVariable = i$.next();
            this.myTemplate.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
        this.updateTemplateContext();
        this.myTemplate.setToReformat(this.myCbReformat.isSelected());
        for (TemplateOptionalProcessor option : this.myCbOptionalProcessorMap.keySet()) {
            JCheckBox cb = this.myCbOptionalProcessorMap.get(option);
            this.myOptions.put(option, cb.isSelected());
        }
        this.myTemplate.setString(this.myTemplateEditor.getDocument().getText());
        this.myTemplate.parseSegments();
    }

    private void updateTemplateContext() {
        for (TemplateContextType type : this.myCbContextMap.keySet()) {
            JCheckBox cb = this.myCbContextMap.get(type);
            this.myContext.put(type, cb.isSelected());
        }
    }

    private void editVariables() {
        this.updateVariablesByTemplateText();
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (Variable myVariable : this.myVariables) {
            Variable variable = myVariable;
            if (TemplateImpl.INTERNAL_VARS_SET.contains(variable.getName())) continue;
            newVariables.add((Variable)variable.clone());
        }
        EditVariableDialog editVariableDialog = new EditVariableDialog(this.myTemplateEditor, this.myEditVariablesButton, newVariables);
        editVariableDialog.show();
        if (!editVariableDialog.isOK()) {
            return;
        }
        this.myVariables = newVariables;
    }

    private void updateVariablesByTemplateText() {
        String name;
        ArrayList<Variable> parsedVariables = new ArrayList<Variable>();
        EditTemplateDialog.parseVariables(this.myTemplateEditor.getDocument().getCharsSequence(), parsedVariables);
        HashMap<String, String> oldVariableNames = new HashMap<String, String>();
        Iterator<Variable> i$ = this.myVariables.iterator();
        while (i$.hasNext()) {
            Variable myVariable;
            Variable oldVariable = myVariable = i$.next();
            String name2 = oldVariable.getName();
            oldVariableNames.put(name2, name2);
        }
        HashMap<String, String> newVariableNames = new HashMap<String, String>();
        Iterator i$2 = parsedVariables.iterator();
        while (i$2.hasNext()) {
            Variable parsedVariable;
            Variable newVariable = parsedVariable = (Variable)i$2.next();
            name = newVariable.getName();
            newVariableNames.put(name, name);
        }
        int oldVariableNumber = 0;
        for (int i = 0; i < parsedVariables.size(); ++i) {
            Variable variable = (Variable)parsedVariables.get(i);
            name = variable.getName();
            if (oldVariableNames.get(name) == null) continue;
            Variable oldVariable = null;
            while (oldVariableNumber < this.myVariables.size() && newVariableNames.get((oldVariable = this.myVariables.get(oldVariableNumber)).getName()) == null) {
                oldVariable = null;
                ++oldVariableNumber;
            }
            ++oldVariableNumber;
            if (oldVariable == null) continue;
            parsedVariables.set(i, oldVariable);
        }
        this.myVariables = parsedVariables;
    }

    private static void parseVariables(CharSequence text, ArrayList variables) {
        TemplateImplUtil.parseVariables(text, variables, TemplateImpl.INTERNAL_VARS_SET);
    }

    protected void doOKAction() {
        String key = this.myKeyField.getText().trim();
        String newGroup = (String)this.myGroupCombo.getSelectedItem();
        for (TemplateGroup templateGroup : this.myTemplateGroups) {
            if (!templateGroup.getName().equals(newGroup)) continue;
            for (TemplateImpl template : templateGroup.getElements()) {
                if (!template.getKey().equals(key) || this.myTemplate == template) continue;
                Messages.showMessageDialog((Component)this.getContentPane(), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.already.exists", (Object[])new Object[]{key, template.getGroupName()}), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (!TemplateImplUtil.validateTemplateText(this.myTemplateEditor.getDocument().getText())) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.malformed.template", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        SchemesManager<TemplateGroup, TemplateGroup> schemesManager = TemplateSettings.getInstance().getSchemesManager();
        TemplateGroup group = (TemplateGroup)schemesManager.findSchemeByName(newGroup);
        if (group != null && schemesManager.isShared((Scheme)group)) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)("Group " + group.getName() + " is shared, cannot be modified"), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }
}

