/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener,
KeyListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.html.preview.ImageOrColorPreviewManager");
    private MergingUpdateQueue myQueue;
    private Editor myEditor;
    private PsiFile myFile;
    private LightweightHint myHint;
    private PsiElement myElement;

    public ImageOrColorPreviewManager(@NotNull TextEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImageOrColorPreviewManager.<init> must not be null");
        }
        this.myEditor = editor.getEditor();
        this.myEditor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        this.myEditor.getContentComponent().addKeyListener(this);
        Document document = this.myEditor.getDocument();
        this.myFile = PsiDocumentManager.getInstance((Project)this.myEditor.getProject()).getPsiFile(document);
        JComponent component = editor.getEditor().getComponent();
        this.myQueue = new MergingUpdateQueue("ImageOrColorPreview", 100, component.isShowing(), component);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editor.getComponent(), (Activatable)this.myQueue));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        PointerInfo pointerInfo;
        if (e.getKeyCode() == 16 && this.myEditor != null && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            Point location = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location, this.myEditor.getContentComponent());
            this.myQueue.cancelAllUpdates();
            this.myQueue.queue((Update)new PreviewUpdate(this, location));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    private PsiElement getPsiElementAt(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImageOrColorPreviewManager.getPsiElementAt must not be null");
        }
        LogicalPosition position = this.getLogicalPosition_(point);
        if (this.myFile != null && !(this.myFile instanceof PsiCompiledElement)) {
            return this.myFile.getViewProvider().findElementAt(this.myEditor.logicalPositionToOffset(position));
        }
        return null;
    }

    private LogicalPosition getLogicalPosition(PsiElement element) {
        return this.myEditor.offsetToLogicalPosition(element.getTextRange().getEndOffset());
    }

    private LogicalPosition getLogicalPosition_(Point point) {
        return this.myEditor.xyToLogicalPosition(point);
    }

    private void setCurrentHint(LightweightHint hint, PsiElement element) {
        if (hint != null) {
            this.myHint = hint;
            this.myElement = element;
        }
    }

    private void showHint(LightweightHint hint, PsiElement element, Editor editor) {
        if (element != this.myElement && element.isValid()) {
            this.hideCurrentHintIfAny();
            this.setCurrentHint(hint, element);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, HintManagerImpl.getHintPosition(hint, editor, this.getLogicalPosition(element), (short)5), 122, 0, false);
        }
    }

    private void hideCurrentHindIfOutOfElement(PsiElement e) {
        if (this.myHint != null && e != this.myElement) {
            this.hideCurrentHintIfAny();
        }
    }

    private void hideCurrentHintIfAny() {
        if (this.myHint != null) {
            this.myHint.hide();
            this.myHint = null;
            this.myElement = null;
        }
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
            this.myEditor.getContentComponent().removeKeyListener(this);
        }
        if (this.myQueue != null) {
            this.myQueue.cancelAllUpdates();
            this.myQueue.hideNotify();
        }
        this.myQueue = null;
        this.myEditor = null;
        this.myFile = null;
        this.myHint = null;
    }

    public void mouseMoved(EditorMouseEvent e) {
        this.myQueue.cancelAllUpdates();
        if (this.myHint == null && e.getMouseEvent().getModifiers() == 1) {
            this.myQueue.queue((Update)new PreviewUpdate(this, e.getMouseEvent().getPoint()));
        } else {
            this.hideCurrentHindIfOutOfElement(this.getPsiElementAt(e.getMouseEvent().getPoint()));
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    @Nullable
    private static LightweightHint getHint(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImageOrColorPreviewManager.getHint must not be null");
        }
        for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
            JComponent preview;
            try {
                preview = hintProvider.getPreviewComponent(element);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (preview == null) continue;
            return new LightweightHint(preview);
        }
        return null;
    }

    private static final class PreviewUpdate
    extends Update {
        private final ImageOrColorPreviewManager myManager;
        private final Point myPoint;

        public PreviewUpdate(@NonNls ImageOrColorPreviewManager manager, @NotNull Point point) {
            if (point == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/preview/ImageOrColorPreviewManager$PreviewUpdate.<init> must not be null");
            }
            super((Object)manager);
            this.myManager = manager;
            this.myPoint = point;
        }

        public void run() {
            PsiElement element = this.myManager.getPsiElementAt(this.myPoint);
            if (element != null && element.isValid()) {
                if (PsiDocumentManager.getInstance((Project)element.getProject()).isUncommited(this.myManager.getEditor().getDocument())) {
                    return;
                }
                if (DumbService.getInstance((Project)element.getProject()).isDumb()) {
                    return;
                }
                LightweightHint hint = ImageOrColorPreviewManager.getHint(element);
                if (hint != null) {
                    Editor editor = this.myManager.getEditor();
                    if (editor != null) {
                        this.myManager.showHint(hint, element, editor);
                    }
                } else {
                    this.myManager.hideCurrentHintIfAny();
                }
            }
        }

        public boolean canEat(Update update) {
            return true;
        }
    }
}

