/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilBase;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoDeclarationAction");

    protected CodeInsightActionHandler getHandler() {
        String s = "/java/lang/Object.class";
        return this;
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return true;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoDeclarationAction.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoDeclarationAction.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoDeclarationAction.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        try {
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = GotoDeclarationAction.findTargetElement(project, editor, offset);
            FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
            if (element == null) {
                GotoDeclarationAction.chooseAmbiguousTarget(editor, offset);
                return;
            }
            PsiElement navElement = element.getNavigationElement();
            navElement = TargetElementUtilBase.getInstance().getGotoDeclarationTarget(element, navElement);
            if (navElement instanceof Navigatable) {
                if (((Navigatable)navElement).canNavigate()) {
                    ((Navigatable)navElement).navigate(true);
                }
            } else if (navElement != null) {
                int navOffset = navElement.getTextOffset();
                VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)navElement);
                if (virtualFile != null) {
                    new OpenFileDescriptor(project, virtualFile, navOffset).navigate(true);
                }
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
    }

    private static void chooseAmbiguousTarget(Editor editor, int offset) {
        PsiElementProcessor<PsiElement> navigateProcessor = new PsiElementProcessor<PsiElement>(){

            public boolean execute(PsiElement element) {
                Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)element);
                if (navigatable != null && navigatable.canNavigate()) {
                    navigatable.navigate(true);
                }
                return true;
            }
        };
        boolean found = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]));
        if (!found) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find declaration to go to");
        }
    }

    public static boolean chooseAmbiguousTarget(Editor editor, int offset, PsiElementProcessor<PsiElement> processor, String titlePattern) {
        if (TargetElementUtilBase.inVirtualSpace(editor, offset)) {
            return false;
        }
        PsiReference reference = TargetElementUtilBase.findReference(editor, offset);
        Collection<PsiElement> candidates = GotoDeclarationAction.suggestCandidates(reference);
        if (candidates.size() == 1) {
            PsiElement element = candidates.iterator().next();
            LOG.assertTrue(element != null);
            processor.execute(element);
            return true;
        }
        if (candidates.size() > 1) {
            PsiElement[] elements = candidates.toArray(new PsiElement[candidates.size()]);
            TextRange range = reference.getRangeInElement();
            String refText = range.substring(reference.getElement().getText());
            String title = MessageFormat.format(titlePattern, refText);
            NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)title, processor).showInBestPositionFor(editor);
            return true;
        }
        return false;
    }

    static Collection<PsiElement> suggestCandidates(PsiReference reference) {
        if (reference == null) {
            return Collections.emptyList();
        }
        return TargetElementUtilBase.getInstance().getTargetCandidates(reference);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findTargetElement(Project project, Editor editor, int offset) {
        if (TargetElementUtilBase.inVirtualSpace(editor, offset)) {
            return null;
        }
        return GotoDeclarationAction.findTargetElementNoVS(project, editor, offset);
    }

    @Nullable
    public static PsiElement findTargetElementNoVS(Project project, Editor editor, int offset) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        PsiElement elementAt = file.findElementAt(offset);
        for (GotoDeclarationHandler handler : (GotoDeclarationHandler[])Extensions.getExtensions(GotoDeclarationHandler.EP_NAME)) {
            PsiElement result = handler.getGotoDeclarationTarget(elementAt);
            if (result == null) continue;
            return result;
        }
        int flags = TargetElementUtilBase.getInstance().getAllAccepted() & 0xFFFFFFFD;
        PsiElement element = TargetElementUtilBase.getInstance().findTargetElement(editor, flags, offset);
        if (element != null) {
            return element;
        }
        if (editor instanceof EditorWindow) {
            EditorWindow window = (EditorWindow)editor;
            return GotoDeclarationAction.findTargetElementNoVS(project, window.getDelegate(), window.getDocument().injectedToHost(offset));
        }
        return null;
    }
}

